/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceReference;
import org.switchyard.handlers.MessageTrace;
import org.switchyard.handlers.ReaderTransformer;
import org.switchyard.handlers.StreamTransformer;
import org.switchyard.transform.Transformer;

public class MessageTraceTest {
    private MockDomain _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
        this._domain.getHandlers().add(new MessageTrace());
    }

    @Test
    public void testInMessageTrace() {
        ServiceReference service = this._domain.createInOnlyService(new QName("InTrace"));
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
    }

    @Test
    public void testInOutMessageTrace() throws Exception {
        ServiceReference service = this._domain.createInOutService(new QName("InOutTrace"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange exchange = service.createExchange((ExchangeHandler)new MockHandler());
        exchange.send(exchange.createMessage());
    }

    @Test
    public void testInFaultMessageTrace() throws Exception {
        ServiceReference service = this._domain.createInOutService(new QName("InFaultTrace"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange exchange = service.createExchange((ExchangeHandler)new MockHandler());
        exchange.send(exchange.createMessage());
    }

    @Test
    public void testStreamContent() throws Exception {
        String contentAsString = "abc-InputStream-xyz";
        MockHandler provider = new MockHandler();
        this._domain.getTransformerRegistry().addTransformer((Transformer)new StreamTransformer());
        ServiceReference service = this._domain.createInOnlyService(new QName("StreamTest"), (ExchangeHandler)provider);
        ByteArrayInputStream contentAsStream = new ByteArrayInputStream(contentAsString.getBytes());
        Exchange ex = service.createExchange();
        Message msg = ex.createMessage();
        msg.setContent((Object)contentAsStream);
        ex.send(msg);
        Message rcvdMsg = provider.getMessages().poll().getMessage();
        Assert.assertTrue((((InputStream)rcvdMsg.getContent(InputStream.class)).available() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReaderContent() throws Exception {
        String contentAsString = "abc-Reader-xyz";
        MockHandler provider = new MockHandler();
        this._domain.getTransformerRegistry().addTransformer((Transformer)new ReaderTransformer());
        ServiceReference service = this._domain.createInOnlyService(new QName("ReaderTest"), (ExchangeHandler)provider);
        StringReader contentAsReader = new StringReader(contentAsString);
        Exchange ex = service.createExchange();
        Message msg = ex.createMessage();
        msg.setContent((Object)contentAsReader);
        ex.send(msg);
        Message rcvdMsg = provider.getMessages().poll().getMessage();
        Assert.assertTrue((((Reader)rcvdMsg.getContent(Reader.class)).read() != -1 ? 1 : 0) != 0);
    }
}

