/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.MockExchange;
import org.switchyard.handlers.MockTransaction;
import org.switchyard.handlers.MockTransactionManager;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public class TransactionHandlerTest {
    private MockTransactionManager tm;
    private MockExchange exchange;
    private TransactionHandler handler;

    @Before
    public void setUp() {
        this.tm = new MockTransactionManager();
        this.exchange = new MockExchange();
        this.handler = new TransactionHandler();
        this.handler.setTransactionManager((TransactionManager)this.tm);
    }

    @Test
    public void incompatibleRequirements_PropagatesAndSuspends() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void incompatibleRequirements_managedGlobalAndmanagedLocal() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void incompatibleRequirements_managedGlobalAndNoManaged() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void incompatibleRequirements_managedLocalAndNoManaged() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void incompatibleRequirements_PropagatesAndManagedLocal() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void incompatibleRequirements_PropagatesAndNoManaged() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void propagatesRequiredButNoTransaction() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to invalid policy");
    }

    @Test
    public void propagateProvidedButNotRequired() throws Exception {
        PolicyUtil.provide((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected when transaction is provided but not required: " + (Object)((Object)handlerEx)));
        }
    }

    @Test
    public void propagateRequiredAndProvided() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.provide((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        MockTransaction tx = this.tm.getTransaction();
        this.handler.handleMessage((Exchange)this.exchange);
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertEquals((Object)tx, (Object)tx2);
        Assert.assertEquals((int)0, (int)tx2.getStatus());
    }

    @Test
    public void propagateRequiredAndProvidedWithManagedGlobalRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        this.propagateRequiredAndProvided();
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL));
    }

    @Test
    public void propagateRequiredButNotProvidedWithManagedGlobalRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        this.exchange.setPhase(ExchangePhase.IN);
        Assert.assertEquals(null, (Object)this.tm.getTransaction());
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx = this.tm.getTransaction();
        Assert.assertEquals((int)0, (int)tx.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION));
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertEquals((int)3, (int)tx.getStatus());
    }

    @Test
    public void managedLocalRequiredWithNoTransactionProvided() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
        this.exchange.setPhase(ExchangePhase.IN);
        Assert.assertEquals(null, (Object)this.tm.getTransaction());
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx = this.tm.getTransaction();
        Assert.assertEquals((int)0, (int)tx.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertEquals((int)3, (int)tx.getStatus());
    }

    @Test
    public void transactionRolledbackByHandler() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        this.exchange.setPhase(ExchangePhase.IN);
        Assert.assertEquals(null, (Object)this.tm.getTransaction());
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx = this.tm.getTransaction();
        Assert.assertEquals((int)0, (int)tx.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION));
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL));
        tx.setRollbackOnly();
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertEquals((int)4, (int)tx.getStatus());
    }

    @Test
    public void suspendAndManagedGlobalRequiredButNoTransaction() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        this.exchange.setPhase(ExchangePhase.IN);
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertEquals((int)0, (int)tx2.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION));
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertEquals((int)3, (int)tx2.getStatus());
    }

    @Test
    public void suspendAndManagedGlobalRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        MockTransaction tx1 = this.tm.getTransaction();
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertNotSame((Object)tx1, (Object)tx2);
        Assert.assertEquals((int)0, (int)tx1.getStatus());
        Assert.assertEquals((int)0, (int)tx2.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION));
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertEquals((Object)tx1, (Object)this.tm.getTransaction());
        Assert.assertEquals((int)0, (int)tx1.getStatus());
        Assert.assertEquals((int)3, (int)tx2.getStatus());
    }

    @Test
    public void suspendsAndManagedLocalRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        MockTransaction tx1 = this.tm.getTransaction();
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertNotSame((Object)tx1, (Object)tx2);
        Assert.assertEquals((int)0, (int)tx1.getStatus());
        Assert.assertEquals((int)0, (int)tx2.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION));
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx3 = this.tm.getTransaction();
        Assert.assertEquals((Object)tx1, (Object)tx3);
        Assert.assertEquals((int)3, (int)tx2.getStatus());
        Assert.assertEquals((int)0, (int)tx3.getStatus());
    }

    @Test
    public void noManagedRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        MockTransaction tx1 = this.tm.getTransaction();
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertNotNull((Object)tx1);
        Assert.assertNull((Object)tx2);
        Assert.assertEquals((int)0, (int)tx1.getStatus());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx3 = this.tm.getTransaction();
        Assert.assertEquals((Object)tx1, (Object)tx3);
        Assert.assertEquals((int)0, (int)tx3.getStatus());
    }

    @Test
    public void suspendsRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.tm.begin();
        MockTransaction tx1 = this.tm.getTransaction();
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertNull((Object)this.tm.getTransaction());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION));
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        MockTransaction tx2 = this.tm.getTransaction();
        Assert.assertEquals((Object)tx1, (Object)tx2);
        Assert.assertEquals((int)0, (int)tx2.getStatus());
    }

    @Test
    public void suspendAndNoManagedRequired() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.suspendsRequired();
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION));
    }

    @Test
    public void suspendRequiredButNoTransaction() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertNull((Object)this.tm.getTransaction());
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertNull((Object)this.tm.getTransaction());
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION));
    }

    @Test
    public void suspendAndNoManagedRequiredButNoTransaction() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
        this.suspendRequiredButNoTransaction();
        Assert.assertTrue((boolean)PolicyUtil.isProvided((Exchange)this.exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION));
    }
}

