/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.ContextProperty;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.ScopedPropertyMap;
import org.switchyard.serial.CompressionType;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public final class ContextSerializationTest {
    @Test
    public void testContextProperty() throws Exception {
        this.assertContextProperty(this.serDeser(this.buildContextProperty(), ContextProperty.class));
    }

    @Test
    public void testScopedPropertyMap() throws Exception {
        this.assertScopedPropertyMap(this.serDeser(this.buildScopedPropertyMap(), ScopedPropertyMap.class));
    }

    @Test
    public void testDefaultContext() throws Exception {
        this.assertDefaultContext(this.serDeser(this.buildDefaultContext(), DefaultContext.class));
    }

    private ContextProperty buildContextProperty() {
        ContextProperty cp = new ContextProperty("foo", Scope.EXCHANGE, (Object)"bar");
        cp.addLabels(new String[]{"baz", "whiz"});
        return cp;
    }

    private ScopedPropertyMap buildScopedPropertyMap() {
        ScopedPropertyMap spm = new ScopedPropertyMap();
        spm.put((Property)this.buildContextProperty());
        return spm;
    }

    private DefaultContext buildDefaultContext() {
        return new DefaultContext(this.buildScopedPropertyMap());
    }

    private void assertContextProperty(ContextProperty cp) {
        Assert.assertNotNull((Object)cp);
        Assert.assertEquals((String)"foo", (String)cp.getName());
        Assert.assertSame((Object)Scope.EXCHANGE, (Object)cp.getScope());
        Assert.assertEquals((Object)"bar", (Object)cp.getValue());
        Set labels = cp.getLabels();
        Assert.assertEquals((int)2, (int)labels.size());
        Assert.assertTrue((boolean)labels.contains("baz"));
        Assert.assertTrue((boolean)labels.contains("whiz"));
        Assert.assertFalse((boolean)labels.contains("beep"));
    }

    private void assertScopedPropertyMap(ScopedPropertyMap spm) {
        Assert.assertNotNull((Object)spm);
        this.assertContextProperty((ContextProperty)spm.get().iterator().next());
    }

    private void assertDefaultContext(DefaultContext dc) {
        Assert.assertNotNull((Object)dc);
        this.assertContextProperty((ContextProperty)dc.getProperties().iterator().next());
    }

    private <T> T serDeser(T obj, Class<T> type) throws Exception {
        FormatType format = FormatType.JSON;
        CompressionType compression = null;
        Serializer ser = SerializerFactory.create((FormatType)format, compression, (boolean)true);
        byte[] bytes = ser.serialize(obj, type);
        return (T)ser.deserialize(bytes, type);
    }
}

