/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.internal.ExceptionToStringTransformer;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.transform.Transformer;

public class ExchangeImplTest {
    private MockDomain _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
    }

    @Test
    public void testSendFaultOnNewExchange() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain);
        try {
            exchange.sendFault(exchange.createMessage());
            Assert.fail((String)"Sending a fault on a new exchange is not allowed");
        }
        catch (IllegalStateException illEx) {
            return;
        }
    }

    @Test
    public void testPhaseIsNullOnNewExchange() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain);
        Assert.assertNull((Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsInAfterInputMessage() {
        ServiceReference service = this._domain.createInOnlyService(new QName("InPhase"));
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertEquals((Object)ExchangePhase.IN, (Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsOutAfterOutputMessage() {
        MockHandler replyHandler = new MockHandler();
        ServiceReference service = this._domain.createInOutService(new QName("OutPhase"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        exchange.send(exchange.createMessage());
        replyHandler.waitForOKMessage();
        Assert.assertEquals((Object)ExchangePhase.OUT, (Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsOutAfterFaultMessage() {
        MockHandler replyHandler = new MockHandler();
        ServiceReference service = this._domain.createInOutService(new QName("FaultPhase"), (ExchangeHandler)new MockHandler().forwardInToFault());
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        exchange.send(exchange.createMessage());
        replyHandler.waitForFaultMessage();
        Assert.assertEquals((Object)ExchangePhase.OUT, (Object)exchange.getPhase());
    }

    @Test
    public void testMessageIdSetOnSend() {
        ServiceReference service = this._domain.createInOnlyService(new QName("IdTest"));
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertNotNull((Object)exchange.getContext().getProperty("org.switchyard.messageId", Scope.IN));
    }

    @Test
    public void testRelatesToSetOnReply() {
        ServiceReference service = this._domain.createInOutService(new QName("ReplyTest"), (ExchangeHandler)new MockHandler().forwardInToOut());
        MockHandler replyHandler = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        exchange.send(exchange.createMessage());
        String requestId = (String)exchange.getContext().getProperty("org.switchyard.messageId", Scope.IN).getValue();
        String replyId = (String)exchange.getContext().getProperty("org.switchyard.messageId", Scope.OUT).getValue();
        String replyRelatesTo = (String)exchange.getContext().getProperty("org.switchyard.relatesTo", Scope.OUT).getValue();
        Assert.assertEquals((String)requestId, (String)replyRelatesTo);
        Assert.assertFalse((boolean)requestId.equals(replyId));
    }

    @Test
    public void testNullSend() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain);
        try {
            exchange.send(null);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Invalid null 'message' argument in method call.", (String)e.getMessage());
        }
    }

    @Test
    public void testNullSendFault() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain);
        try {
            exchange.sendFault(null);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Invalid null 'message' argument in method call.", (String)e.getMessage());
        }
    }

    @Test
    public void testExchangeCompletedEvent() {
        class CompletionCounter
        implements EventObserver {
            int count;

            CompletionCounter() {
            }

            public void notify(EventObject event) {
                if (event instanceof ExchangeCompletionEvent) {
                    ++this.count;
                }
            }
        }
        CompletionCounter counter = new CompletionCounter();
        this._domain.addEventObserver(counter, ExchangeCompletionEvent.class);
        ServiceReference inOnlyService = this._domain.createInOnlyService(new QName("ExchangeCompleteEvent-1"));
        Exchange inOnly = inOnlyService.createExchange();
        inOnly.send(inOnly.createMessage());
        Assert.assertEquals((int)1, (int)counter.count);
        counter.count = 0;
        ServiceReference inOutService = this._domain.createInOutService(new QName("ExchangeCompleteEvent-2"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange inOut = inOutService.createExchange((ExchangeHandler)new MockHandler());
        inOut.send(inOut.createMessage());
        Assert.assertEquals((int)1, (int)counter.count);
    }

    @Test
    public void testGetMessage() throws Exception {
        QName serviceName = new QName("bleh");
        String inMsgContent = "in message";
        String outMsgContent = "out message";
        BaseHandler provider = new BaseHandler(){

            public void handleMessage(Exchange exchange) {
                Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"in message");
                Message outMsg = exchange.createMessage();
                outMsg.setContent((Object)"out message");
                try {
                    exchange.send(outMsg);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.toString());
                }
            }
        };
        BaseHandler consumer = new BaseHandler(){

            public void handleMessage(Exchange exchange) {
                Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"out message");
            }
        };
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange((ExchangeHandler)consumer);
        Message inMsg = exchange.createMessage();
        inMsg.setContent((Object)"in message");
        exchange.send(inMsg);
    }

    @Test
    public void testExceptionOnSendOnFaultExchange() throws Exception {
        QName serviceName = new QName("testExceptionOnSendOnFaultExchange");
        MockHandler provider = new MockHandler().forwardInToFault();
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        MockHandler consumer = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)consumer);
        exchange.send(exchange.createMessage());
        provider.waitForOKMessage();
        consumer.waitForFaultMessage();
        try {
            exchange.send(exchange.createMessage());
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Exchange instance is in a FAULT state.", (String)e.getMessage());
        }
    }

    @Test
    public void testExceptionOnNoConsumerOnInOut() throws Exception {
        QName serviceName = new QName("testNoNPEOnNoConsumer");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("explode");
            }
        };
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        try {
            service.createExchange();
            Assert.fail((String)"Should not be able to create an InOut without specifying a reply handler");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testNoNPEOnInOnlyFault() throws Exception {
        QName serviceName = new QName("testNoNPEOnNoConsumer");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("explode");
            }
        };
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
    }

    @Test
    public void testFaultWithNoHandler() throws Exception {
        QName serviceName = new QName("testFaultWithNoHandler");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("Fault With No Handler!");
            }
        };
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertEquals((Object)ExchangeState.FAULT, (Object)exchange.getState());
    }

    @Test
    public void testFaultTransformSequence() throws Exception {
        QName serviceName = new QName("testFaultTransformSequence");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                Message fault = exchange.createMessage();
                fault.setContent((Object)new Exception("testFaultTransformSequence"));
                exchange.sendFault(fault);
            }
        };
        InOutOperation providerContract = new InOutOperation("faultOp", JavaService.toMessageType(String.class), JavaService.toMessageType(String.class), JavaService.toMessageType(Exception.class));
        InOutOperation consumerContract = new InOutOperation("faultOp", JavaService.toMessageType(String.class), JavaService.toMessageType(String.class), JavaService.toMessageType(String.class));
        this._domain.registerService(serviceName, (ServiceInterface)new InOutService(providerContract), (ExchangeHandler)provider);
        this._domain.getTransformerRegistry().addTransformer((Transformer)new ExceptionToStringTransformer());
        ServiceReference service = this._domain.registerServiceReference(serviceName, (ServiceInterface)new InOutService(consumerContract));
        Exchange exchange = service.createExchange((ExchangeHandler)new MockHandler());
        exchange.send(exchange.createMessage());
        Assert.assertEquals(String.class, exchange.getMessage().getContent().getClass());
        Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"testFaultTransformSequence");
    }
}

