/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.validate;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.validate.BaseValidator;

public class BaseValidatorTest {
    @Test
    public void testGetName_default_with_generics() {
        BaseValidator<String> strv = new BaseValidator<String>(){

            public boolean validate(String obj) {
                return obj != null;
            }
        };
        Assert.assertEquals((String)"java:java.lang.String", (String)strv.getName().toString());
    }

    @Test
    public void testGetName_default_without_generics() {
        BaseValidator strv = new BaseValidator(){

            public boolean validate(Object obj) {
                return obj != null;
            }
        };
        Assert.assertEquals((String)"java:java.lang.Object", (String)strv.getName().toString());
    }

    @Test
    public void testGetName_specified_with_generics() {
        QName name = new QName("string1");
        BaseValidator<String> strv = new BaseValidator<String>(name){

            public boolean validate(String obj) {
                return obj != null;
            }
        };
        Assert.assertEquals((Object)name, (Object)strv.getName());
    }

    @Test
    public void testGetName_specified_without_generics() {
        QName name = new QName("string1");
        BaseValidator strv = new BaseValidator(name){

            public boolean validate(Object obj) {
                return obj != null;
            }
        };
        Assert.assertEquals((Object)name, (Object)strv.getName());
    }
}

