/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Service;
import org.switchyard.spi.ServiceRegistry;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static Logger _logger = Logger.getLogger(DefaultServiceRegistry.class);
    private final Map<QName, List<Service>> _services = new HashMap<QName, List<Service>>();

    @Override
    public synchronized List<Service> getServices() {
        LinkedList<Service> serviceList = new LinkedList<Service>();
        for (List<Service> services : this._services.values()) {
            serviceList.addAll(services);
        }
        return serviceList;
    }

    @Override
    public synchronized List<Service> getServices(QName serviceName) {
        if (!this._services.containsKey(serviceName)) {
            return Collections.emptyList();
        }
        return new LinkedList<Service>((Collection)this._services.get(serviceName));
    }

    @Override
    public synchronized Service registerService(Service service) {
        if (!this._services.containsKey(service.getName())) {
            this._services.put(service.getName(), new LinkedList());
        }
        this._services.get(service.getName()).add(service);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Registered Service '" + service.getName() + "'."));
        }
        return service;
    }

    @Override
    public synchronized void unregisterService(Service service) {
        List<Service> serviceList = this._services.get(service.getName());
        if (serviceList != null) {
            serviceList.remove(service);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unregistered Service '" + service.getName() + "' from ServiceDomain '" + service.getDomain().getName() + "'."));
            }
        }
    }
}

