/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.DefaultContext;
import org.switchyard.label.BehaviorLabel;

public class DefaultContextTest {
    private static final String TRANSIENT = BehaviorLabel.TRANSIENT.label();
    private static final String PROP_NAME = "foo";
    private static final String PROP_VAL = "bar";
    private DefaultContext _context;

    @Before
    public void setUp() {
        this._context = new DefaultContext();
    }

    @Test
    public void testGetSet() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Assert.assertEquals((Object)PROP_VAL, (Object)this._context.getProperty(PROP_NAME).getValue());
    }

    @Test
    public void testGetSetScoped() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL, Scope.IN);
        Assert.assertEquals((Object)PROP_VAL, (Object)this._context.getProperty(PROP_NAME, Scope.IN).getValue());
        Assert.assertNull((Object)this._context.getProperty(PROP_NAME));
        Assert.assertNull((Object)this._context.getProperty(PROP_NAME, Scope.OUT));
    }

    @Test
    public void testGetPropertyValue() {
        String key = "prop";
        String value = "exchange";
        this._context.setProperty("prop", (Object)"exchange");
        this._context.setProperty("prop", (Object)"in", Scope.IN);
        this._context.setProperty("prop", (Object)"out", Scope.OUT);
        Assert.assertEquals((Object)"exchange", (Object)this._context.getPropertyValue("prop"));
    }

    @Test
    public void testRemove() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Property p = this._context.getProperty(PROP_NAME);
        Assert.assertEquals((Object)PROP_VAL, (Object)p.getValue());
        this._context.removeProperty(p);
        Assert.assertNull((Object)this._context.getProperty(PROP_NAME));
    }

    @Test
    public void testRemoveScopedProperites() {
        this._context.setProperty("out", (Object)PROP_VAL, Scope.OUT);
        this._context.setProperty("in", (Object)PROP_NAME, Scope.IN);
        this._context.removeProperties(Scope.IN);
        Assert.assertNull((Object)this._context.getProperty("in", Scope.IN));
        Assert.assertNotNull((Object)this._context.getProperty("out", Scope.OUT));
    }

    @Test
    public void testRemoveProperites() {
        this._context.setProperty("out", (Object)PROP_VAL, Scope.OUT);
        this._context.setProperty("in", (Object)PROP_NAME, Scope.IN);
        this._context.setProperty("ex", (Object)"psst", Scope.EXCHANGE);
        this._context.removeProperties();
        Assert.assertNull((Object)this._context.getPropertyValue("in"));
        Assert.assertNull((Object)this._context.getPropertyValue("out"));
        Assert.assertNull((Object)this._context.getPropertyValue("ex"));
    }

    @Test
    public void testNullContextValue() {
        this._context.setProperty(PROP_NAME, null);
        Property p = this._context.getProperty(PROP_NAME);
        Assert.assertNotNull((Object)p);
        Assert.assertNull((Object)p.getValue());
    }

    @Test
    public void testSetPropertySet() {
        this._context.setProperty("one", (Object)PROP_VAL);
        this._context.setProperty("two", (Object)PROP_NAME);
        Set props = this._context.getProperties(Scope.EXCHANGE);
        DefaultContext ctx = new DefaultContext();
        ctx.setProperties(props);
        Assert.assertNotNull((Object)ctx.getPropertyValue("one"));
        Assert.assertNotNull((Object)ctx.getPropertyValue("two"));
    }

    @Test
    public void testGetProperties() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Set props = this._context.getProperties();
        Assert.assertTrue((props.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)PROP_VAL, (Object)((Property)props.iterator().next()).getValue());
        props.remove(PROP_NAME);
        Assert.assertTrue((this._context.getProperties().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPropertyLabel() {
        this._context.setProperty("a", (Object)"a", Scope.IN).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b", Scope.OUT).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("c", (Object)"c", Scope.EXCHANGE).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("d", (Object)"d", Scope.IN).addLabels(new String[]{PROP_NAME});
        Assert.assertEquals((long)3L, (long)this._context.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)this._context.getProperties(PROP_NAME).size());
    }

    @Test
    public void testRemovePropertyLabel() {
        this._context.setProperty("a", (Object)"a", Scope.IN).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b", Scope.OUT).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("c", (Object)"c", Scope.EXCHANGE).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("d", (Object)"d", Scope.IN).addLabels(new String[]{PROP_NAME});
        this._context.removeProperties(TRANSIENT);
        Assert.assertEquals((long)0L, (long)this._context.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)this._context.getProperties(PROP_NAME).size());
    }

    @Test
    public void testCopyClean() {
        this._context.setProperty("a", (Object)"a", Scope.IN).addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b", Scope.OUT);
        this._context.setProperty("c", (Object)"c", Scope.EXCHANGE).addLabels(new String[]{TRANSIENT});
        Context newCtx = this._context.copy();
        Assert.assertEquals((long)0L, (long)newCtx.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)newCtx.getProperties().size());
    }

    @Test
    public void testCopy() {
        this._context.setProperty("exchange", (Object)"val", Scope.EXCHANGE);
        this._context.setProperty("in", (Object)"val", Scope.IN);
        this._context.setProperty("out", (Object)"val", Scope.OUT);
        Context ctx = this._context.copy();
        Assert.assertEquals((Object)this._context.getProperty("exchange", Scope.EXCHANGE), (Object)ctx.getProperty("exchange", Scope.EXCHANGE));
        Assert.assertEquals((Object)this._context.getProperty("in", Scope.IN), (Object)ctx.getProperty("in", Scope.IN));
        Assert.assertEquals((Object)this._context.getProperty("out", Scope.OUT), (Object)ctx.getProperty("out", Scope.OUT));
        this._context.removeProperties(Scope.EXCHANGE);
        Assert.assertNull((Object)this._context.getProperty("exchange", Scope.EXCHANGE));
        Assert.assertNotNull((Object)ctx.getProperty("exchange", Scope.EXCHANGE));
    }
}

