/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.validate;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;

public class BaseValidatorRegistryTest {
    private ValidatorRegistry _registry;

    @Before
    public void setUp() throws Exception {
        this._registry = new BaseValidatorRegistry();
    }

    @Test
    public void testAddGetValidator() {
        QName name = new QName("a");
        BaseValidator<String> t = new BaseValidator<String>(name){

            public ValidationResult validate(String obj) {
                if (obj != null) {
                    return 1.validResult();
                }
                return 1.invalidResult((String)"obj == null");
            }
        };
        this._registry.addValidator((Validator)t);
        Assert.assertEquals((Object)t, (Object)this._registry.getValidator(name));
    }

    @Test
    public void test_fallbackValidatorComparator_resolvable() {
        ArrayList<BaseValidatorRegistry.JavaSourceFallbackValidator> validatorsList = new ArrayList<BaseValidatorRegistry.JavaSourceFallbackValidator>();
        validatorsList.add(new BaseValidatorRegistry.JavaSourceFallbackValidator(C.class, null));
        validatorsList.add(new BaseValidatorRegistry.JavaSourceFallbackValidator(E.class, null));
        validatorsList.add(new BaseValidatorRegistry.JavaSourceFallbackValidator(D.class, null));
        validatorsList.add(new BaseValidatorRegistry.JavaSourceFallbackValidator(A.class, null));
        validatorsList.add(new BaseValidatorRegistry.JavaSourceFallbackValidator(B.class, null));
        BaseValidatorRegistry.JavaSourceFallbackValidatorComparator comparator = new BaseValidatorRegistry.JavaSourceFallbackValidatorComparator();
        Collections.sort(validatorsList, comparator);
        Assert.assertTrue((((BaseValidatorRegistry.JavaSourceFallbackValidator)validatorsList.get(0)).getJavaType() == E.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseValidatorRegistry.JavaSourceFallbackValidator)validatorsList.get(1)).getJavaType() == D.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseValidatorRegistry.JavaSourceFallbackValidator)validatorsList.get(2)).getJavaType() == C.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseValidatorRegistry.JavaSourceFallbackValidator)validatorsList.get(3)).getJavaType() == B.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseValidatorRegistry.JavaSourceFallbackValidator)validatorsList.get(4)).getJavaType() == A.class ? 1 : 0) != 0);
    }

    @Test
    public void test_getFallbackValidator_resolvable() {
        this.addValidator(B.class);
        this.addValidator(C.class);
        Validator validator = this._registry.getValidator(this.getType(A.class));
        Assert.assertNull((Object)validator);
        validator = this._registry.getValidator(this.getType(D.class));
        Assert.assertNotNull((Object)validator);
        Assert.assertEquals((Object)this.getType(C.class), (Object)validator.getName());
    }

    private void addValidator(Class<?> type) {
        QName name = this.getType(type);
        this._registry.addValidator((Validator)new TestValidator(name));
    }

    private QName getType(Class<?> type) {
        return JavaService.toMessageType(type);
    }

    public class TestValidator
    extends BaseValidator {
        public TestValidator(QName name) {
            super(name);
        }

        public ValidationResult validate(Object obj) {
            if (obj != null) {
                return TestValidator.validResult();
            }
            return TestValidator.invalidResult((String)"obj != null");
        }
    }

    public static interface I {
    }

    public class E
    extends D {
    }

    public class D
    extends C
    implements I {
    }

    public class C
    extends B {
    }

    public class B
    extends A {
    }

    public class A {
    }
}

