/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tests;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;

public class ValidationTest {
    private MockDomain _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidationByName() throws Exception {
        QName serviceName = new QName("nameValidate");
        QName typeName = new QName("A");
        String input = "Hello";
        BaseValidator<String> helloValidate = new BaseValidator<String>(typeName){

            public ValidationResult validate(String obj) {
                if (obj.equals("Hello")) {
                    return 1.validResult();
                }
                return 1.invalidResult((String)"obj.equals(\"Hello\") was false");
            }
        };
        this._domain.getValidatorRegistry().addValidator((Validator)helloValidate);
        try {
            MockHandler provider = new MockHandler();
            ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
            Exchange exchange = service.createExchange();
            Message msg = exchange.createMessage().setContent((Object)"Hello");
            exchange.getContext().setProperty("org.switchyard.contentType", (Object)typeName, Scope.IN);
            msg.setContent((Object)"Hello");
            exchange.send(msg);
            provider.waitForOKMessage();
            Assert.assertEquals((Object)provider.getMessages().poll().getMessage().getContent(), (Object)"Hello");
        }
        finally {
            this._domain.getValidatorRegistry().removeValidator((Validator)helloValidate);
        }
    }

    @Test
    public void testValidationsFailed() throws Exception {
        QName serviceName = new QName("nameValidate");
        QName typeName = new QName("A");
        String input = "Hello";
        BaseValidator<String> failValidate = new BaseValidator<String>(typeName){

            public ValidationResult validate(String obj) {
                return 2.invalidResult((String)"validation fail test");
            }
        };
        this._domain.getValidatorRegistry().addValidator((Validator)failValidate);
        MockHandler provider = new MockHandler();
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        MockHandler invokerHandler = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)invokerHandler);
        Message msg = exchange.createMessage().setContent((Object)"Hello");
        exchange.getContext().setProperty("org.switchyard.contentType", (Object)typeName, Scope.IN);
        msg.setContent((Object)"Hello");
        exchange.send(msg);
        invokerHandler.waitForFaultMessage();
        Object content = invokerHandler.getFaults().poll().getMessage().getContent();
        Assert.assertTrue((boolean)(content instanceof HandlerException));
        Assert.assertEquals((String)"Validator 'org.switchyard.tests.ValidationTest$2' failed: validation fail test", (String)((HandlerException)((Object)content)).getMessage());
    }
}

