/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.ServiceSecurity;
import org.switchyard.event.DomainShutdownEvent;
import org.switchyard.event.DomainStartupEvent;
import org.switchyard.event.EventObserver;
import org.switchyard.event.EventPublisher;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.event.ReferenceUnregistrationEvent;
import org.switchyard.event.ServiceRegistrationEvent;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DefaultServiceSecurity;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.ServiceImpl;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.policy.Policy;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class DomainImpl
implements ServiceDomain {
    private static Logger _logger = Logger.getLogger(DomainImpl.class);
    private final QName _name;
    private final ServiceSecurity _security;
    private EventManager _eventManager;
    private ServiceRegistry _registry;
    private ExchangeBus _exchangeBus;
    private TransformerRegistry _transformerRegistry;
    private ValidatorRegistry _validatorRegistry;
    private List<ExchangeHandler> _userHandlers = new LinkedList<ExchangeHandler>();
    private Map<String, Object> _attachements = Collections.synchronizedMap(new LinkedHashMap());
    private Map<QName, ServiceReference> _references = new ConcurrentHashMap<QName, ServiceReference>();

    public DomainImpl(QName name) {
        this(name, new DefaultServiceSecurity(), new DefaultServiceRegistry(), new LocalExchangeBus(), new BaseTransformerRegistry(), new BaseValidatorRegistry(), new EventManager());
    }

    public DomainImpl(QName name, ServiceSecurity security, ServiceRegistry registry, ExchangeBus exchangeBus, TransformerRegistry transformerRegistry, ValidatorRegistry validatorRegistry, EventManager eventManager) {
        this._name = name;
        this._security = security;
        this._registry = registry;
        this._exchangeBus = exchangeBus;
        this._transformerRegistry = transformerRegistry;
        this._validatorRegistry = validatorRegistry;
        this._eventManager = eventManager;
        this.setEventPublisher(this._transformerRegistry);
        this.setEventPublisher(this._validatorRegistry);
        this._eventManager.publish((EventObject)new DomainStartupEvent((ServiceDomain)this));
        this._exchangeBus.init(this);
        this._exchangeBus.start();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created SwitchYard ServiceDomain instance '" + name + "'."));
        }
    }

    public Service registerService(QName serviceName, ServiceInterface metadata, ExchangeHandler handler) {
        List<Policy> requires = Collections.emptyList();
        return this.registerService(serviceName, metadata, handler, requires, null);
    }

    public Service registerService(QName serviceName, ServiceInterface metadata, ExchangeHandler handler, List<Policy> requires, Registrant owner) {
        if (metadata == null) {
            metadata = new InOutService();
        }
        ServiceImpl service = new ServiceImpl(serviceName, metadata, this, handler, requires, owner);
        this._registry.registerService(service);
        this._eventManager.publish((EventObject)new ServiceRegistrationEvent((Service)service));
        return service;
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata) {
        return this.registerServiceReference(serviceName, metadata, null, null, null, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata, ExchangeHandler handler) {
        return this.registerServiceReference(serviceName, metadata, handler, null, null, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata, ExchangeHandler handler, List<Policy> provides, List<Policy> requires, Registrant owner) {
        ServiceReferenceImpl reference = new ServiceReferenceImpl(serviceName, metadata, this, provides, requires, handler, owner);
        Dispatcher dispatch = this._exchangeBus.createDispatcher(reference);
        reference.setDispatcher(dispatch);
        this._references.put(serviceName, reference);
        this._eventManager.publish((EventObject)new ReferenceRegistrationEvent((ServiceReference)reference));
        return reference;
    }

    public ServiceReference getServiceReference(QName serviceName) {
        return this._references.get(serviceName);
    }

    public void unregisterServiceReference(ServiceReference reference) {
        this._references.remove(reference.getName());
        this._eventManager.publish((EventObject)new ReferenceUnregistrationEvent(reference));
    }

    public QName getName() {
        return this._name;
    }

    public ServiceSecurity getServiceSecurity() {
        return this._security;
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._transformerRegistry;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this._validatorRegistry;
    }

    public List<Service> getServices() {
        return this._registry.getServices();
    }

    public List<Service> getServices(QName serviceName) {
        return this._registry.getServices(serviceName);
    }

    public ServiceRegistry getServiceRegistry() {
        return this._registry;
    }

    public ExchangeBus getBus() {
        return this._exchangeBus;
    }

    public void destroy() {
        this._exchangeBus.stop();
        this._eventManager.publish((EventObject)new DomainShutdownEvent((ServiceDomain)this));
        this._references.clear();
    }

    public ServiceDomain addEventObserver(EventObserver observer, Class<? extends EventObject> eventType) {
        this._eventManager.addObserver(observer, eventType);
        return this;
    }

    public EventPublisher getEventPublisher() {
        return this._eventManager;
    }

    public List<ExchangeHandler> getHandlers() {
        return this._userHandlers;
    }

    public Map<String, Object> getProperties() {
        return this._attachements;
    }

    private void setEventPublisher(Object target) {
        if (target == null) {
            return;
        }
        try {
            Method setter = target.getClass().getMethod("setEventPublisher", EventPublisher.class);
            setter.invoke(target, this._eventManager);
        }
        catch (Exception ex) {
            _logger.debug((Object)("Attempt to set EventPublisher failed on " + target.getClass().getCanonicalName()), (Throwable)ex);
        }
    }

    public String toString() {
        return "ServiceDomain [name=" + this._name + "]";
    }
}

