/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tests;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceReference;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;

public class TransformationTest {
    private MockDomain _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformationByName() throws Exception {
        QName serviceName = new QName("nameTransform");
        QName inType = new QName("fromA");
        QName expectedDestType = new QName("toB");
        String input = "Hello";
        String output = "Hello SwitchYard";
        BaseTransformer<String, String> helloTransform = new BaseTransformer<String, String>(inType, expectedDestType){

            public String transform(String from) {
                return from + " SwitchYard";
            }
        };
        this._domain.getTransformerRegistry().addTransformer((Transformer)helloTransform);
        try {
            MockHandler provider = new MockHandler();
            ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
            Exchange exchange = service.createExchange();
            Message msg = exchange.createMessage().setContent((Object)"Hello");
            TransformSequence.from((QName)inType).to(expectedDestType).associateWith(msg);
            msg.setContent((Object)"Hello");
            exchange.send(msg);
            provider.waitForOKMessage();
            Assert.assertEquals((Object)provider.getMessages().poll().getMessage().getContent(), (Object)"Hello SwitchYard");
        }
        finally {
            this._domain.getTransformerRegistry().removeTransformer((Transformer)helloTransform);
        }
    }

    @Test
    public void testTransformationsNotApplied() throws Exception {
        QName serviceName = new QName("nameTransform");
        QName inType = new QName("fromA");
        QName expectedDestType = new QName("toB");
        String input = "Hello";
        MockHandler provider = new MockHandler();
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        MockHandler invokerHandler = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)invokerHandler);
        Message msg = exchange.createMessage().setContent((Object)"Hello");
        TransformSequence.from((QName)inType).to(expectedDestType).associateWith(msg);
        msg.setContent((Object)"Hello");
        exchange.send(msg);
        invokerHandler.waitForFaultMessage();
        Object content = invokerHandler.getFaults().poll().getMessage().getContent();
        Assert.assertTrue((boolean)(content instanceof HandlerException));
        Assert.assertEquals((String)"Transformations not applied.  Required payload type of 'toB'.  Actual payload type is 'fromA'.  You must define and register a Transformer to transform between these types.", (String)((HandlerException)((Object)content)).getMessage());
    }
}

