/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceMetadata;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.event.ReferenceUnregistrationEvent;
import org.switchyard.internal.DomainImpl;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceMetadataBuilder;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.spi.Dispatcher;

public class ServiceReferenceImpl
implements ServiceReference {
    private QName _name;
    private ServiceInterface _interface;
    private DomainImpl _domain;
    private ExchangeHandler _handler;
    private Dispatcher _dispatcher;
    private QName _targetServiceName;
    private ServiceMetadata _metadata;

    public ServiceReferenceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ServiceMetadata metadata) {
        this(name, serviceInterface, domain, null, metadata);
    }

    public ServiceReferenceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ExchangeHandler handler, ServiceMetadata metadata) {
        this._name = name;
        this._interface = serviceInterface;
        this._handler = handler;
        this._domain = domain;
        this._targetServiceName = name;
        this._metadata = metadata != null ? metadata : ServiceMetadataBuilder.create().build();
    }

    public Exchange createExchange() {
        return this.createExchange(this._handler);
    }

    public Exchange createExchange(ExchangeHandler handler) {
        Set operations = this._interface.getOperations();
        if (operations.size() == 0) {
            throw new SwitchYardException("No operations in interface for service: " + this._name);
        }
        if (operations.size() > 1) {
            throw new SwitchYardException("Operation name required - multiple operations on service interface: " + this._name);
        }
        return this.createExchange(((ServiceOperation)operations.iterator().next()).getName(), handler);
    }

    public Exchange createExchange(String operation) {
        return this.createExchange(operation, this._handler);
    }

    public Exchange createExchange(String operation, ExchangeHandler handler) {
        ServiceOperation op = this._interface.getOperation(operation);
        if (op == null) {
            if ("esb".equals(this._interface.getType())) {
                op = (ServiceOperation)this._interface.getOperations().iterator().next();
            } else {
                throw new SwitchYardException("Operation " + operation + " does not exist for service " + this._name);
            }
        }
        Exchange ex = this._dispatcher.createExchange(handler, op.getExchangePattern());
        ex.consumer((ServiceReference)this, op);
        for (Policy policy : this._metadata.getRequiredPolicies()) {
            PolicyUtil.require((Exchange)ex, (Policy)policy);
        }
        for (Policy policy : this._metadata.getProvidedPolicies()) {
            PolicyUtil.provide((Exchange)ex, (Policy)policy);
        }
        return ex;
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public void unregister() {
        this._domain.getServiceRegistry().unregisterServiceReference(this);
        this._domain.getEventPublisher().publish((EventObject)new ReferenceUnregistrationEvent((ServiceReference)this));
    }

    public ServiceReferenceImpl setHandler(ExchangeHandler handler) {
        this._handler = handler;
        return this;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public ServiceReferenceImpl setDispatcher(Dispatcher dispatcher) {
        this._dispatcher = dispatcher;
        return this;
    }

    public void wire(QName serviceName) {
        this._targetServiceName = serviceName;
    }

    public QName getTargetServiceName() {
        return this._targetServiceName;
    }

    public ServiceMetadata getServiceMetadata() {
        return this._metadata;
    }

    public String toString() {
        return "ServiceReference [name=" + this._name + ", interface=" + this._interface + ", domain=" + this._domain + "]";
    }
}

