/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.event.EventPublisher;
import org.switchyard.event.TransformerAddedEvent;
import org.switchyard.event.TransformerRemovedEvent;
import org.switchyard.internal.transform.BaseTransformResolver;
import org.switchyard.transform.TransformResolver;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class BaseTransformerRegistry
implements TransformerRegistry {
    private static Logger _log = Logger.getLogger(BaseTransformerRegistry.class);
    private static final int DEFAULT_HASHCODE = 32;
    private final ConcurrentHashMap<NameKey, Transformer<?, ?>> _transformers = new ConcurrentHashMap();
    private final ConcurrentHashMap<NameKey, Transformer<?, ?>> _fallbackTransformers = new ConcurrentHashMap();
    private EventPublisher _eventPublisher;
    private TransformResolver _transformResolver = new BaseTransformResolver(this);

    public BaseTransformerRegistry() {
    }

    public BaseTransformerRegistry(Set<Transformer<?, ?>> transformers) {
        for (Transformer<?, ?> t : transformers) {
            this.addTransformer((Transformer)t);
        }
    }

    public BaseTransformerRegistry addTransformer(Transformer<?, ?> transformer) {
        this._fallbackTransformers.clear();
        this._transformers.put(new NameKey(transformer.getFrom(), transformer.getTo()), transformer);
        this.publishEvent((EventObject)new TransformerAddedEvent(transformer));
        return this;
    }

    public TransformerRegistry addTransformer(Transformer<?, ?> transformer, QName from, QName to) {
        this._fallbackTransformers.clear();
        this._transformers.put(new NameKey(from, to), transformer);
        this.publishEvent((EventObject)new TransformerAddedEvent(transformer));
        return null;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this._eventPublisher = eventPublisher;
    }

    public Transformer<?, ?> getTransformer(QName from, QName to) {
        NameKey nameKey = new NameKey(from, to);
        Transformer<?, ?> transformer = this._transformers.get(nameKey);
        if (transformer == null) {
            transformer = this._fallbackTransformers.get(nameKey);
            if (transformer == null && QNameUtil.isJavaMessageType((QName)from)) {
                transformer = this.getJavaFallbackTransformer(from, to);
                if (transformer != null && _log.isDebugEnabled()) {
                    _log.debug((Object)("Selecting fallback transformer: from '" + transformer.getFrom() + "' to '" + transformer.getTo() + "'. Type: " + transformer.getClass().getName()));
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No compatible transformer registered: from '" + from + "' to '" + to + "'"));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Selecting transformer: from '" + transformer.getFrom() + "' to '" + transformer.getTo() + "'. Type: " + transformer.getClass().getName()));
        }
        return transformer;
    }

    public TransformSequence getTransformSequence(QName from, QName to) {
        return this._transformResolver.resolveSequence(from, to);
    }

    public boolean hasTransformer(QName from, QName to) {
        NameKey nameKey = new NameKey(from, to);
        return this._transformers.containsKey(nameKey);
    }

    private Transformer<?, ?> getJavaFallbackTransformer(QName from, QName to) {
        Class javaType = QNameUtil.toJavaMessageType((QName)from);
        if (javaType == null) {
            return null;
        }
        Set<Map.Entry<NameKey, Transformer<?, ?>>> entrySet = this._transformers.entrySet();
        ArrayList<JavaSourceFallbackTransformer> fallbackTransforms = new ArrayList<JavaSourceFallbackTransformer>();
        for (Map.Entry<NameKey, Transformer<?, ?>> entry : entrySet) {
            Class candidateType;
            NameKey nameKey = entry.getKey();
            if (!((QName)nameKey.getTo()).equals(to) || !QNameUtil.isJavaMessageType((QName)((QName)nameKey.getFrom())) || (candidateType = QNameUtil.toJavaMessageType((QName)((QName)nameKey.getFrom()))) == null || !candidateType.isAssignableFrom(javaType)) continue;
            fallbackTransforms.add(new JavaSourceFallbackTransformer(candidateType, entry.getValue()));
        }
        if (fallbackTransforms.size() == 0) {
            return null;
        }
        if (fallbackTransforms.size() == 1) {
            Transformer<?, ?> fallbackTransformer = ((JavaSourceFallbackTransformer)fallbackTransforms.get(0)).getTransformer();
            this.addFallbackTransformer(fallbackTransformer, from, to);
            return fallbackTransformer;
        }
        JavaSourceFallbackTransformerComparator comparator = new JavaSourceFallbackTransformerComparator();
        Collections.sort(fallbackTransforms, comparator);
        if (_log.isDebugEnabled()) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Multiple possible fallback transformers available:");
            for (JavaSourceFallbackTransformer t : fallbackTransforms) {
                messageBuilder.append("\n\t- from '" + t.getTransformer().getFrom() + "' to '" + t.getTransformer().getTo() + "'");
            }
            _log.debug((Object)messageBuilder.toString());
        }
        Transformer<?, ?> fallbackTransformer = ((JavaSourceFallbackTransformer)fallbackTransforms.get(0)).getTransformer();
        this.addFallbackTransformer(fallbackTransformer, from, to);
        return fallbackTransformer;
    }

    private void addFallbackTransformer(Transformer<?, ?> fallbackTransformer, QName from, QName to) {
        this._fallbackTransformers.put(new NameKey(from, to), fallbackTransformer);
    }

    public boolean removeTransformer(Transformer<?, ?> transformer) {
        boolean removed;
        this._fallbackTransformers.clear();
        boolean bl = removed = this._transformers.remove(new NameKey(transformer.getFrom(), transformer.getTo())) != null;
        if (removed) {
            this.publishEvent((EventObject)new TransformerRemovedEvent(transformer));
        }
        return removed;
    }

    public List<Transformer<?, ?>> getRegisteredTransformers() {
        return new ArrayList(this._transformers.values());
    }

    public List<Transformer<?, ?>> getTransformersFrom(QName type) {
        LinkedList transforms = new LinkedList();
        for (NameKey key : this._transformers.keySet()) {
            if (key.getFrom() == null || !((QName)key.getFrom()).equals(type)) continue;
            transforms.add(this._transformers.get(key));
        }
        return transforms;
    }

    public List<Transformer<?, ?>> getTransformersTo(QName type) {
        LinkedList transforms = new LinkedList();
        for (NameKey key : this._transformers.keySet()) {
            if (key.getTo() == null || !((QName)key.getTo()).equals(type)) continue;
            transforms.add(this._transformers.get(key));
        }
        return transforms;
    }

    public void setTransfomResolver(TransformResolver resolver) {
        this._transformResolver = resolver;
    }

    private void publishEvent(EventObject event) {
        if (this._eventPublisher != null) {
            this._eventPublisher.publish(event);
        }
    }

    public static class JavaSourceFallbackTransformerComparator<T extends JavaSourceFallbackTransformer>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T t1, T t2) {
            if (((JavaSourceFallbackTransformer)t1).getJavaType() == ((JavaSourceFallbackTransformer)t2).getJavaType()) {
                return 0;
            }
            if (((JavaSourceFallbackTransformer)t1).getJavaType().isAssignableFrom(((JavaSourceFallbackTransformer)t2).getJavaType())) {
                return 1;
            }
            if (((JavaSourceFallbackTransformer)t2).getJavaType().isAssignableFrom(((JavaSourceFallbackTransformer)t1).getJavaType())) {
                return -1;
            }
            return 0;
        }
    }

    public static class JavaSourceFallbackTransformer {
        private Class<?> _javaType;
        private Transformer<?, ?> _transformer;

        public JavaSourceFallbackTransformer(Class<?> javaType, Transformer<?, ?> transformer) {
            this._javaType = javaType;
            this._transformer = transformer;
        }

        public Class<?> getJavaType() {
            return this._javaType;
        }

        public Transformer<?, ?> getTransformer() {
            return this._transformer;
        }
    }

    private class Key<F, T> {
        private final F _from;
        private final T _to;

        Key(F from, T to) {
            this._from = from;
            this._to = to;
        }

        public F getFrom() {
            return this._from;
        }

        public T getTo() {
            return this._to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !Key.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            return this.isEqual(this._from, ((Key)obj).getFrom()) && this.isEqual(this._to, ((Key)obj).getTo());
        }

        public int hashCode() {
            return (this._from != null ? this._from.hashCode() : 31) + (this._to != null ? this._to.hashCode() : 32);
        }

        public String toString() {
            return this._from + "::" + this._to;
        }

        private boolean isEqual(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }

    private class NameKey
    extends Key<QName, QName> {
        NameKey(QName from, QName to) {
            super(from, to);
        }
    }
}

