/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.Context;
import org.switchyard.ContextUtil;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.ContextProperty;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.Strategy;

@Strategy(access=AccessType.FIELD)
public class DefaultContext
implements Context {
    private Scope _scope;
    private final Map<String, Property> _properties;

    public DefaultContext(Scope defaultScope, Map<String, Property> properties) {
        this._scope = defaultScope;
        this._properties = properties;
    }

    public DefaultContext(Scope defaultScope) {
        this(defaultScope, new HashMap<String, Property>());
    }

    public DefaultContext() {
        this(Scope.EXCHANGE);
    }

    public <T> T getPropertyValue(String name) {
        Property prop = this._properties.get(name);
        if (prop != null) {
            return (T)prop.getValue();
        }
        return null;
    }

    public void removeProperties() {
        this._properties.clear();
    }

    public Context setProperties(Set<Property> properties) {
        for (Property p : properties) {
            this._properties.put(p.getName(), p);
        }
        return this;
    }

    public Set<Property> getProperties() {
        return new HashSet<Property>(this._properties.values());
    }

    public void removeProperty(Property property) {
        ContextUtil.checkScope((Scope)this._scope, (Scope)property.getScope());
        this._properties.remove(property.getName());
    }

    public Property getProperty(String name) {
        return this._properties.get(name);
    }

    public Property setProperty(String name, Object val) {
        ContextProperty p = new ContextProperty(name, this._scope, val);
        this._properties.put(p.getName(), p);
        return p;
    }

    public Context copy() {
        return ContextUtil.copy((Context)this, (Context)new DefaultContext(this._scope, new HashMap<String, Property>()));
    }

    public Set<Property> getProperties(String label) {
        HashSet<Property> props = new HashSet<Property>();
        for (Property p : this.getProperties()) {
            if (!p.hasLabel(label)) continue;
            props.add(p);
        }
        return props;
    }

    public void removeProperties(String label) {
        for (Property p : this.getProperties()) {
            if (!p.hasLabel(label)) continue;
            this.removeProperty(p);
        }
    }

    public Property getProperty(String name, Scope scope) {
        ContextUtil.checkScope((Scope)this._scope, (Scope)scope);
        return this._properties.get(name);
    }

    public Set<Property> getProperties(Scope scope) {
        ContextUtil.checkScope((Scope)this._scope, (Scope)scope);
        return this.getProperties();
    }

    public void removeProperties(Scope scope) {
        ContextUtil.checkScope((Scope)this._scope, (Scope)scope);
        this._properties.clear();
    }

    public Property setProperty(String name, Object val, Scope scope) {
        ContextUtil.checkScope((Scope)this._scope, (Scope)scope);
        ContextProperty value = new ContextProperty(name, scope, val);
        this._properties.put(name, value);
        return value;
    }

    public void setScope(Scope scope) {
        this._scope = scope;
    }

    public String toString() {
        return this._properties.toString();
    }
}

