/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.switchyard.BaseHandler;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerChain;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.handlers.AddressingHandler;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.handlers.SecurityHandler;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.handlers.ValidateHandler;
import org.switchyard.internal.DefaultHandlerChain;
import org.switchyard.internal.LocalDispatcher;
import org.switchyard.internal.ProviderHandler;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;

public class LocalExchangeBus
implements ExchangeBus {
    private ConcurrentHashMap<QName, Dispatcher> _dispatchers = new ConcurrentHashMap();
    private HandlerChain _requestChain;
    private HandlerChain _replyChain;
    private ServiceDomain _domain;

    @Override
    public void init(ServiceDomain domain) {
        this._domain = domain;
        TransactionHandler transactionHandler = new TransactionHandler();
        SecurityHandler securityHandler = new SecurityHandler();
        TransformHandler transformHandler = new TransformHandler(domain.getTransformerRegistry());
        ValidateHandler validateHandler = new ValidateHandler(domain.getValidatorRegistry());
        this._requestChain = new DefaultHandlerChain();
        this._requestChain.addLast("addressing", (ExchangeHandler)new AddressingHandler(this._domain));
        this._requestChain.addLast("transaction-pre-invoke", (ExchangeHandler)transactionHandler);
        this._requestChain.addLast("security", (ExchangeHandler)securityHandler);
        this._requestChain.addLast("generic-policy", (ExchangeHandler)new PolicyHandler());
        this._requestChain.addLast("validation-before-transform", (ExchangeHandler)validateHandler);
        this._requestChain.addLast("transformation", (ExchangeHandler)transformHandler);
        this._requestChain.addLast("validation-after-transform", (ExchangeHandler)validateHandler);
        this._requestChain.addLast("provider", (ExchangeHandler)new ProviderHandler());
        this._requestChain.addLast("transaction-post-invoke", (ExchangeHandler)transactionHandler);
        this._replyChain = new DefaultHandlerChain();
        this._replyChain.addLast("validation-before-transform", (ExchangeHandler)validateHandler);
        this._replyChain.addLast("transformation", (ExchangeHandler)transformHandler);
        this._replyChain.addLast("validation-after-transform", (ExchangeHandler)validateHandler);
        this._replyChain.addLast("security", (ExchangeHandler)securityHandler);
        this._replyChain.addLast("consumer", (ExchangeHandler)new BaseHandler());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this._dispatchers.clear();
    }

    @Override
    public synchronized Dispatcher createDispatcher(ServiceReference reference) {
        DefaultHandlerChain userHandlers = DefaultHandlerChain.fromList(this._domain.getHandlers());
        HandlerChain requestChain = this._requestChain.copy();
        HandlerChain replyChain = this._replyChain.copy();
        requestChain.addFirst("domain-handlers", (ExchangeHandler)userHandlers);
        replyChain.addFirst("domain-handlers", (ExchangeHandler)userHandlers);
        LocalDispatcher dispatcher = new LocalDispatcher(this._domain, reference, requestChain, replyChain);
        this._dispatchers.put(reference.getName(), dispatcher);
        return dispatcher;
    }

    @Override
    public Dispatcher getDispatcher(ServiceReference reference) {
        return this._dispatchers.get(reference.getName());
    }
}

