/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceSecurity;
import org.switchyard.event.ServiceUnregistrationEvent;
import org.switchyard.internal.DomainImpl;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.policy.Policy;

public class ServiceImpl
implements Service {
    private QName _name;
    private ServiceInterface _interface;
    private DomainImpl _domain;
    private ExchangeHandler _providerHandler;
    private List<Policy> _requires;
    private String _securityName;
    private Registrant _providerMetadata;

    public ServiceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ExchangeHandler providerHandler) {
        this(name, serviceInterface, domain, providerHandler, null, null, null);
    }

    public ServiceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ExchangeHandler providerHandler, List<Policy> requires, String securityName, Registrant providerMetadata) {
        this._name = name;
        this._interface = serviceInterface;
        this._domain = domain;
        this._providerHandler = providerHandler;
        this._providerMetadata = providerMetadata;
        this._requires = requires != null ? requires : Collections.emptyList();
        this._securityName = securityName;
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public ServiceSecurity getSecurity() {
        return this._domain != null ? this._domain.getServiceSecurity(this._securityName) : null;
    }

    public void unregister() {
        this._domain.getServiceRegistry().unregisterService(this);
        this._domain.getEventPublisher().publish((EventObject)new ServiceUnregistrationEvent((Service)this));
    }

    public List<Policy> getRequiredPolicies() {
        return Collections.unmodifiableList(this._requires);
    }

    public ExchangeHandler getProviderHandler() {
        return this._providerHandler;
    }

    public Registrant getProviderMetadata() {
        return this._providerMetadata;
    }

    public ServiceImpl setRequires(List<Policy> requires) {
        this._requires = requires;
        return this;
    }

    public ServiceImpl setProviderMetadata(Registrant provider) {
        this._providerMetadata = provider;
        return this;
    }

    public String toString() {
        return "Service [name=" + this._name + ", interface=" + this._interface + ", domain=" + this._domain + ", requires=" + this._requires + "]";
    }
}

