/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.util.List;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;

public class AddressingHandler
extends BaseHandler {
    private ServiceDomain _domain;

    public AddressingHandler(ServiceDomain domain) {
        this._domain = domain;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (ExchangePhase.IN != exchange.getPhase()) {
            return;
        }
        if (exchange.getProvider() != null) {
            return;
        }
        List services = this._domain.getServices(exchange.getConsumer().getTargetServiceName());
        if (services == null || services.isEmpty()) {
            throw new SwitchYardException("No registered service found for " + exchange.getConsumer().getName());
        }
        Service service = (Service)services.get(0);
        ServiceOperation consumerOp = exchange.getContract().getConsumerOperation();
        ServiceOperation providerOp = service.getInterface().getOperation(consumerOp.getName());
        if (providerOp == null) {
            if (service.getInterface().getOperations().size() == 1) {
                providerOp = (ServiceOperation)service.getInterface().getOperations().iterator().next();
            } else {
                throw new HandlerException("Operation " + consumerOp.getName() + " is not included in interface for service: " + service.getName());
            }
        }
        exchange.provider(service, providerOp);
        for (Policy policy : service.getServiceMetadata().getRequiredPolicies()) {
            PolicyUtil.require((Exchange)exchange, (Policy)policy);
        }
    }
}

