/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.SwitchYardException;
import org.switchyard.internal.DefaultContext;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class DefaultMessage
implements Message {
    private TransformerRegistry _transformerRegistry;
    private Object _content;
    private Map<String, DataSource> _attachments = new HashMap<String, DataSource>();
    private Context _context = new DefaultContext(Scope.MESSAGE);
    private boolean _sent;

    public DefaultMessage setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this._transformerRegistry = transformerRegistry;
        return this;
    }

    public DefaultMessage addAttachment(String name, DataSource attachment) {
        this._attachments.put(name, attachment);
        return this;
    }

    public DataSource getAttachment(String name) {
        return this._attachments.get(name);
    }

    public void removeAttachment(String name) {
        this._attachments.remove(name);
    }

    public Map<String, DataSource> getAttachmentMap() {
        return new HashMap<String, DataSource>(this._attachments);
    }

    public Object getContent() {
        return this._content;
    }

    public Context getContext() {
        return this._context;
    }

    public <T> T getContent(Class<T> type) {
        QName toType;
        if (type == null) {
            throw new IllegalArgumentException("null 'type' argument.");
        }
        if (this._content == null) {
            return null;
        }
        if (type.isInstance(this._content)) {
            return type.cast(this._content);
        }
        if (this._transformerRegistry == null) {
            throw new SwitchYardException("Cannot convert from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  No TransformRegistry available.");
        }
        QName fromType = JavaTypes.toMessageType(this._content.getClass());
        Transformer transformer = this._transformerRegistry.getTransformer(fromType, toType = JavaTypes.toMessageType(type));
        if (transformer == null) {
            throw new SwitchYardException("Cannot convert from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  No registered Transformer available for transforming from '" + fromType + "' to '" + toType + "'.  A Transformer must be registered.");
        }
        Object transformedContent = transformer.transform(this._content);
        if (transformedContent == null) {
            throw new SwitchYardException("Error converting from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned null.");
        }
        if (!type.isInstance(transformedContent)) {
            throw new SwitchYardException("Error converting from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned incompatible type '" + transformedContent.getClass().getName() + "'.");
        }
        return type.cast(transformedContent);
    }

    public DefaultMessage setContent(Object content) {
        this._content = content;
        return this;
    }

    public Message copy() {
        DefaultMessage message = new DefaultMessage();
        if (this._transformerRegistry != null) {
            message.setTransformerRegistry(this._transformerRegistry);
        }
        return message.setContent(this._content);
    }

    public boolean isSent() {
        return this._sent;
    }

    public void send() {
        this._sent = true;
    }
}

