/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.DefaultContext;
import org.switchyard.label.BehaviorLabel;

public class DefaultContextTest {
    private static final String TRANSIENT = BehaviorLabel.TRANSIENT.label();
    private static final String PROP_NAME = "foo";
    private static final String PROP_VAL = "bar";
    private DefaultContext _context;

    @Before
    public void setUp() {
        this._context = new DefaultContext(Scope.EXCHANGE);
    }

    @Test
    public void testGetSet() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Assert.assertEquals((Object)PROP_VAL, (Object)this._context.getProperty(PROP_NAME).getValue());
    }

    @Test
    public void testGetPropertyValue() {
        String key = "prop";
        String value = "exchange";
        this._context.setProperty("prop", (Object)"exchange");
        Assert.assertEquals((Object)"exchange", (Object)this._context.getPropertyValue("prop"));
    }

    @Test
    public void testRemove() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Property p = this._context.getProperty(PROP_NAME);
        Assert.assertEquals((Object)PROP_VAL, (Object)p.getValue());
        this._context.removeProperty(p);
        Assert.assertNull((Object)this._context.getProperty(PROP_NAME));
    }

    @Test
    public void testRemoveProperites() {
        this._context.setProperty("out", (Object)PROP_VAL);
        this._context.setProperty("in", (Object)PROP_NAME);
        this._context.setProperty("ex", (Object)"psst");
        this._context.removeProperties();
        Assert.assertNull((Object)this._context.getPropertyValue("in"));
        Assert.assertNull((Object)this._context.getPropertyValue("out"));
        Assert.assertNull((Object)this._context.getPropertyValue("ex"));
    }

    @Test
    public void testNullContextValue() {
        this._context.setProperty(PROP_NAME, null);
        Property p = this._context.getProperty(PROP_NAME);
        Assert.assertNotNull((Object)p);
        Assert.assertNull((Object)p.getValue());
    }

    @Test
    public void testSetPropertySet() {
        this._context.setProperty("one", (Object)PROP_VAL);
        this._context.setProperty("two", (Object)PROP_NAME);
        Set props = this._context.getProperties();
        DefaultContext ctx = new DefaultContext(Scope.MESSAGE);
        ctx.setProperties(props);
        Assert.assertNotNull((Object)ctx.getPropertyValue("one"));
        Assert.assertNotNull((Object)ctx.getPropertyValue("two"));
    }

    @Test
    public void testGetProperties() {
        this._context.setProperty(PROP_NAME, (Object)PROP_VAL);
        Set props = this._context.getProperties();
        Assert.assertTrue((props.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)PROP_VAL, (Object)((Property)props.iterator().next()).getValue());
        props.remove(PROP_NAME);
        Assert.assertTrue((this._context.getProperties().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPropertyLabel() {
        this._context.setProperty("a", (Object)"a").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("c", (Object)"c").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("d", (Object)"d").addLabels(new String[]{PROP_NAME});
        Assert.assertEquals((long)3L, (long)this._context.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)this._context.getProperties(PROP_NAME).size());
    }

    @Test
    public void testRemovePropertyLabel() {
        this._context.setProperty("a", (Object)"a").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("c", (Object)"c").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("d", (Object)"d").addLabels(new String[]{PROP_NAME});
        this._context.removeProperties(TRANSIENT);
        Assert.assertEquals((long)0L, (long)this._context.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)this._context.getProperties(PROP_NAME).size());
    }

    @Test
    public void testCopyClean() {
        this._context.setProperty("a", (Object)"a").addLabels(new String[]{TRANSIENT});
        this._context.setProperty("b", (Object)"b");
        this._context.setProperty("c", (Object)"c").addLabels(new String[]{TRANSIENT});
        DefaultContext newCtx = new DefaultContext(Scope.EXCHANGE);
        this._context.mergeInto((Context)newCtx);
        Assert.assertEquals((long)0L, (long)newCtx.getProperties(TRANSIENT).size());
        Assert.assertEquals((long)1L, (long)newCtx.getProperties().size());
    }

    @Test
    public void testCopy() {
        this._context.setProperty("exchange", (Object)"val");
        this._context.setProperty("in", (Object)"val");
        this._context.setProperty("out", (Object)"val");
        DefaultContext ctx = new DefaultContext(Scope.EXCHANGE);
        this._context.mergeInto((Context)ctx);
        Assert.assertEquals((Object)this._context.getProperty("exchange"), (Object)ctx.getProperty("exchange"));
        Assert.assertEquals((Object)this._context.getProperty("in"), (Object)ctx.getProperty("in"));
        Assert.assertEquals((Object)this._context.getProperty("out"), (Object)ctx.getProperty("out"));
        this._context.removeProperties();
        Assert.assertNull((Object)this._context.getProperty("exchange"));
        Assert.assertNotNull((Object)ctx.getProperty("exchange"));
    }
}

