/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.internal.CompositeContext;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.runtime.RuntimeLogger;
import org.switchyard.runtime.RuntimeMessages;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.runtime.event.ExchangeInitiatedEvent;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.SecurityExchange;
import org.switchyard.spi.Dispatcher;

public class ExchangeImpl
implements SecurityExchange {
    private static Logger _log = Logger.getLogger(ExchangeImpl.class);
    private ExchangePhase _phase;
    private Message _message;
    private ExchangeState _state = ExchangeState.OK;
    private Dispatcher _dispatch;
    private ExchangeHandler _replyHandler;
    private ServiceDomain _domain;
    private Long _startTime;
    private SecurityContext _securityContext = new SecurityContext();
    private Context _context;
    private CompositeContext _compositeContext;
    private ServiceReference _consumer;
    private Service _provider;
    private BaseExchangeContract _contract = new BaseExchangeContract();

    public ExchangeImpl(ServiceDomain domain, Dispatcher dispatcher) {
        this(domain, dispatcher, null);
    }

    public ExchangeImpl(ServiceDomain domain, Dispatcher dispatch, ExchangeHandler replyHandler) {
        this._domain = domain;
        this._dispatch = dispatch;
        this._replyHandler = replyHandler;
        this._context = new DefaultContext();
        this._compositeContext = new CompositeContext();
        this._compositeContext.setContext(Scope.EXCHANGE, this._context);
    }

    public SecurityContext getSecurityContext() {
        return this._securityContext;
    }

    public Context getContext() {
        return this._compositeContext;
    }

    public Context getContext(Message message) {
        if (this._message != null && this._message == message) {
            return this.getContext();
        }
        return message.getContext();
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void send(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            this._phase = ExchangePhase.IN;
            this.initContentType(message);
        } else if (this._phase.equals((Object)ExchangePhase.IN)) {
            this._phase = ExchangePhase.OUT;
            this.initContentType(message);
            Object propertyValue = this._message.getContext().getPropertyValue("org.switchyard.messageId");
            message.getContext().setProperty("org.switchyard.relatesTo", propertyValue).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        } else {
            throw RuntimeMessages.MESSAGES.sendMessageNotAllowed(this._phase.toString());
        }
        this.sendInternal(message);
    }

    public synchronized void sendFault(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            throw RuntimeMessages.MESSAGES.sendFaultNotAllowed();
        }
        this._phase = ExchangePhase.OUT;
        this._state = ExchangeState.FAULT;
        this.initFaultContentType();
        message.getContext().setProperty("org.switchyard.relatesTo", this._message.getContext().getPropertyValue("org.switchyard.messageId")).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        this.sendInternal(message);
    }

    public ExchangeState getState() {
        return this._state;
    }

    public Dispatcher getDispatcher() {
        return this._dispatch;
    }

    public ExchangeHandler getReplyHandler() {
        return this._replyHandler;
    }

    public ExchangePattern getPattern() {
        ExchangePattern pattern = null;
        if (this.getContract() != null) {
            pattern = this.getContract().getConsumerOperation().getExchangePattern();
        }
        return pattern;
    }

    private void sendInternal(Message message) {
        if (this._startTime == null) {
            this._startTime = System.nanoTime();
        }
        ExchangePhase sendPhase = this._phase;
        this._message = message;
        this._message.getContext().setProperty("org.switchyard.messageId", (Object)UUID.randomUUID().toString()).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        this._compositeContext.setContext(Scope.MESSAGE, this._message.getContext());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending " + this._phase + " Message (" + System.identityHashCode(message) + ") on " + this._contract.getConsumerOperation().getExchangePattern() + " Exchange (" + this.instanceHash() + ") for Service '" + this._consumer.getName() + "', operation '" + this._contract.getProviderOperation() + "'.  Exchange state: " + this._state));
        }
        if (ExchangeState.FAULT.equals((Object)this._state) && this._replyHandler == null) {
            String faultContent;
            try {
                faultContent = (String)this._message.getContent(String.class);
            }
            catch (Exception ex) {
                faultContent = this._message.getContent().toString();
            }
            RuntimeLogger.ROOT_LOGGER.faultGeneratedDuringExchange(faultContent);
        } else {
            if (ExchangePhase.IN.equals((Object)this.getPhase())) {
                this.getContext().setProperty("org.switchyard.exchangeInitiatedNS.start", (Object)Long.toString(System.nanoTime()));
                this._domain.getEventPublisher().publish((EventObject)new ExchangeInitiatedEvent((Exchange)this));
            }
            this._dispatch.dispatch((Exchange)this);
        }
        if (this.isDone(sendPhase)) {
            long duration = System.nanoTime() - this._startTime;
            this.getContext().setProperty("org.switchyard.exchangeDurationMS", (Object)TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS)).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            this._domain.getEventPublisher().publish((EventObject)new ExchangeCompletionEvent((Exchange)this));
        }
    }

    private int instanceHash() {
        return System.identityHashCode(this);
    }

    private void assertMessageOK(Message message) {
        if (message == null) {
            throw RuntimeMessages.MESSAGES.invalidMessageArgument();
        }
        if (this._state == ExchangeState.FAULT) {
            throw RuntimeMessages.MESSAGES.exchangeInFaultState();
        }
        if (!(message instanceof DefaultMessage)) {
            throw RuntimeMessages.MESSAGES.onlyDefaultMessageInstances();
        }
        if (((DefaultMessage)message).isSent()) {
            throw RuntimeMessages.MESSAGES.messageOnlySentOnce();
        }
        ((DefaultMessage)message).send();
    }

    public Message createMessage() {
        DefaultMessage msg = new DefaultMessage();
        if (this._domain != null) {
            msg.setTransformerRegistry(this._domain.getTransformerRegistry());
        }
        if (this._message == null) {
            this._compositeContext.setContext(Scope.MESSAGE, msg.getContext());
        }
        return msg;
    }

    public ExchangePhase getPhase() {
        return this._phase;
    }

    public ExchangeContract getContract() {
        return this._contract;
    }

    public ServiceReference getConsumer() {
        return this._consumer;
    }

    public Service getProvider() {
        return this._provider;
    }

    public ExchangeImpl consumer(ServiceReference consumer, ServiceOperation operation) {
        if (this._phase != null) {
            throw RuntimeMessages.MESSAGES.cannotChangeMetaDataAfterMessageSent();
        }
        if (this._replyHandler == null && operation.getExchangePattern() == ExchangePattern.IN_OUT) {
            throw RuntimeMessages.MESSAGES.invalidConsumerContract();
        }
        this._consumer = consumer;
        this._contract.setConsumerOperation(operation);
        return this;
    }

    public ExchangeImpl provider(Service provider, ServiceOperation operation) {
        if (this._phase == ExchangePhase.OUT) {
            throw RuntimeMessages.MESSAGES.cannotChangeMetadataAfterInvoke();
        }
        this._provider = provider;
        this._contract.setProviderOperation(operation);
        return this;
    }

    protected void setPhase(ExchangePhase phase) {
        this._phase = phase;
    }

    protected void setMessage(Message message) {
        this._message = message;
    }

    private void initContentType(Message message) {
        QName exchangeInputType = this._contract.getConsumerOperation().getInputType();
        if (exchangeInputType != null) {
            message.getContext().setProperty("org.switchyard.contentType", (Object)exchangeInputType, Scope.MESSAGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private void initFaultContentType() {
        QName serviceOperationFaultType;
        if (this._contract.getProviderOperation() != null && (serviceOperationFaultType = this._contract.getProviderOperation().getFaultType()) != null) {
            this._message.getContext().setProperty("org.switchyard.faultType", (Object)serviceOperationFaultType, Scope.MESSAGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private boolean isDone(ExchangePhase phase) {
        ExchangePattern mep = this._contract.getConsumerOperation().getExchangePattern();
        return ExchangePhase.IN.equals((Object)phase) && ExchangePattern.IN_ONLY.equals((Object)mep) || ExchangePhase.OUT.equals((Object)phase) && ExchangePattern.IN_OUT.equals((Object)mep);
    }
}

