/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.ServiceImpl;
import org.switchyard.internal.ServiceReferenceImpl;

public class DefaultServiceRegistryTest {
    @Test
    public void shouldBePossibleToSearchForNonRegisteredService() {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        List services = registry.getServices(new QName("unRegisteredService"));
        Assert.assertThat((Object)services.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testUnregister() {
        QName serviceName = new QName("Foo");
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        ServiceImpl service = new ServiceImpl(serviceName, null, null, null);
        registry.registerService((Service)service);
        Assert.assertTrue((registry.getServices(serviceName).size() > 0 ? 1 : 0) != 0);
        registry.unregisterService((Service)service);
        Assert.assertTrue((registry.getServices(serviceName).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullServiceDomainName() {
        Logger logger = Logger.getLogger(DefaultServiceRegistry.class);
        Level origLevel = logger.getLevel();
        logger.setLevel(Level.DEBUG);
        Assert.assertEquals((Object)logger.getLevel(), (Object)Level.DEBUG);
        QName serviceName = new QName("FooBar");
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        DomainImpl domain = new DomainImpl(null);
        ServiceImpl service = new ServiceImpl(serviceName, null, domain, null);
        registry.registerService((Service)service);
        Assert.assertTrue((service.getDomain().getName() == null ? 1 : 0) != 0);
        registry.unregisterService((Service)service);
        logger.setLevel(origLevel);
    }

    @Test
    public void referenceRegistration() {
        QName referenceName = new QName("Bar");
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        ServiceReferenceImpl reference = new ServiceReferenceImpl(referenceName, null, null, null);
        registry.registerServiceReference((ServiceReference)reference);
        Assert.assertTrue((registry.getServiceReferences().size() > 0 ? 1 : 0) != 0);
        registry.unregisterServiceReference((ServiceReference)reference);
        Assert.assertTrue((registry.getServices(referenceName).size() == 0 ? 1 : 0) != 0);
    }
}

