/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.MockExchange;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;

public class PolicyHandlerTest {
    private static final QName FOO_POLICY_QNAME = new QName("foo");
    private static final QName BAR_POLICY_QNAME = new QName("bar");
    private MockExchange exchange;
    private PolicyHandler handler;

    @Before
    public void setUp() {
        this.exchange = new MockExchange();
        this.handler = new PolicyHandler();
    }

    @Test
    public void requiredButNotProvided() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)new FooPolicy());
        PolicyUtil.require((Exchange)this.exchange, (Policy)new BarPolicy());
        PolicyUtil.provide((Exchange)this.exchange, (Policy)new BarPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void providedButNotRequired() {
        PolicyUtil.provide((Exchange)this.exchange, (Policy)new FooPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected when policy is provided but not required: " + (Object)((Object)handlerEx)));
        }
    }

    @Test
    public void requiredAndProvided() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)new FooPolicy());
        PolicyUtil.provide((Exchange)this.exchange, (Policy)new FooPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected, required policy is provided: " + (Object)((Object)handlerEx)));
        }
    }

    private class BarPolicy
    implements Policy {
        private BarPolicy() {
        }

        public QName getQName() {
            return BAR_POLICY_QNAME;
        }

        public String getName() {
            return this.getQName().getLocalPart();
        }

        public String toString() {
            return this.getQName().toString();
        }

        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.INTERACTION;
        }

        public boolean isCompatibleWith(Policy target) {
            return true;
        }

        public Policy getPolicyDependency() {
            return null;
        }
    }

    private class FooPolicy
    implements Policy {
        private FooPolicy() {
        }

        public QName getQName() {
            return FOO_POLICY_QNAME;
        }

        public String getName() {
            return this.getQName().getLocalPart();
        }

        public String toString() {
            return this.getQName().toString();
        }

        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.INTERACTION;
        }

        public boolean isCompatibleWith(Policy target) {
            return true;
        }

        public Policy getPolicyDependency() {
            return null;
        }
    }
}

