/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.MockHandler;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.internal.CountingEventObserver;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.MyInterface;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;

public class DomainImplTest {
    private static final QName IN_ONLY_SERVICE = new QName("InOnlyService");
    private static final QName IN_OUT_SERVICE = new QName("InOutService");
    private ServiceReference _inOnlyReference;
    private ServiceReference _inOutReference;
    private DomainImpl _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new DomainImpl(new QName("test"));
        this._domain.registerService(IN_ONLY_SERVICE, (ServiceInterface)new InOnlyService(), (ExchangeHandler)new MockHandler());
        this._domain.registerService(IN_OUT_SERVICE, (ServiceInterface)new InOutService(), (ExchangeHandler)new MockHandler());
        this._inOnlyReference = this._domain.registerServiceReference(IN_ONLY_SERVICE, (ServiceInterface)new InOnlyService());
        this._inOutReference = this._domain.registerServiceReference(IN_OUT_SERVICE, (ServiceInterface)new InOutService());
    }

    @Test
    public void testCreateExchange() {
        Exchange inOnly = this._inOnlyReference.createExchange();
        inOnly.consumer(null, (ServiceOperation)new InOnlyOperation("foo"));
        Assert.assertEquals((Object)ExchangePattern.IN_ONLY, (Object)inOnly.getContract().getConsumerOperation().getExchangePattern());
        Exchange inOut = this._inOutReference.createExchange((ExchangeHandler)new MockHandler());
        inOut.consumer(null, (ServiceOperation)new InOutOperation("foo"));
        Assert.assertEquals((Object)ExchangePattern.IN_OUT, (Object)inOut.getContract().getConsumerOperation().getExchangePattern());
    }

    @Test
    public void testRegisterServiceWithoutInterface() {
        Service service = this._domain.registerService(new QName("no-interface"), null, (ExchangeHandler)new MockHandler());
        Assert.assertNotNull((Object)service.getInterface());
        Assert.assertTrue((service.getInterface().getOperations().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)service.getInterface().getOperation(""));
    }

    @Test
    public void testRegisterServiceWithInterface() {
        Service service = this._domain.registerService(new QName("my-interface"), (ServiceInterface)JavaService.fromClass(MyInterface.class), (ExchangeHandler)new MockHandler());
        Assert.assertNotNull((Object)service.getInterface());
        Assert.assertTrue((service.getInterface().getOperations().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)service.getInterface().getOperation("myOperation"));
    }

    @Test
    public void testGetSetProperties() {
        Assert.assertNull((Object)this._domain.getProperty("foo"));
        this._domain.setProperty("foo", (Object)"foo-value");
        Assert.assertEquals((Object)"foo-value", (Object)this._domain.getProperty("foo"));
        Assert.assertEquals((Object)"foo-value", this._domain.getProperties().get("foo"));
        try {
            this._domain.getProperties().put("bar", "bar-value");
            Assert.fail((String)"Should not be able to modify map returned from ServiceDomain.getProperties()");
        }
        catch (Exception ex) {
            Assert.assertEquals(UnsupportedOperationException.class, ex.getClass());
        }
    }

    @Test
    public void testGetEventPublisher() {
        Assert.assertNotNull((Object)this._domain.getEventPublisher());
    }

    @Test
    public void testAddObserver() {
        CountingEventObserver obs = new CountingEventObserver();
        this._domain.addEventObserver((EventObserver)obs, ReferenceRegistrationEvent.class);
        this._domain.getEventPublisher().publish((EventObject)new ReferenceRegistrationEvent(this._inOnlyReference));
        Assert.assertEquals((int)1, (int)obs.count);
    }
}

