/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceSecurity;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.security.SecurityMetadata;
import org.switchyard.security.SecurityServices;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.provider.SecurityProvider;

public class SecurityHandler
extends BaseHandler {
    private static final Logger LOGGER = Logger.getLogger(SecurityHandler.class);
    private static final ThreadLocal<AtomicInteger> PROCESS_COUNT = new InheritableThreadLocal<AtomicInteger>();
    private final SecurityContextManager _securityContextManager;
    private final SecurityProvider _securityProvider;
    private final SecurityAction _securityAction;

    public SecurityHandler(ServiceDomain serviceDomain, SecurityAction securityAction) {
        this._securityContextManager = new SecurityContextManager(serviceDomain);
        this._securityProvider = SecurityServices.getSecurityProvider();
        this._securityAction = securityAction;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        ServiceSecurity serviceSecurity = SecurityMetadata.getServiceSecurity((Exchange)exchange);
        if (serviceSecurity == null) {
            return;
        }
        switch (this._securityAction) {
            case PROCESS: {
                this.process(exchange, serviceSecurity);
                break;
            }
            case CLEANUP: {
                this.cleanup(exchange, serviceSecurity);
            }
        }
    }

    public void handleFault(Exchange exchange) {
        ServiceSecurity serviceSecurity = SecurityMetadata.getServiceSecurity((Exchange)exchange);
        if (serviceSecurity == null) {
            return;
        }
        try {
            this.cleanup(exchange, serviceSecurity);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    private void process(Exchange exchange, ServiceSecurity serviceSecurity) throws HandlerException {
        SecurityHandler.processCount().incrementAndGet();
        SecurityContext securityContext = this._securityContextManager.getContext(exchange);
        if (PolicyUtil.isRequired((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY) && !PolicyUtil.isProvided((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY) && this.isConfidentialityProvided(securityContext)) {
            PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY);
        }
        boolean success = false;
        if (PolicyUtil.isRequired((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION) && !PolicyUtil.isProvided((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION)) {
            if (this.isClientAuthenticationProvided(securityContext)) {
                PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION);
                success = true;
            } else {
                boolean authenticated = this._securityProvider.authenticate(serviceSecurity, securityContext);
                if (authenticated) {
                    PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION);
                    success = true;
                }
            }
        } else {
            success = true;
        }
        if (success) {
            this._securityProvider.populate(serviceSecurity, securityContext);
        }
        if (PolicyUtil.isRequired((Exchange)exchange, (Policy)SecurityPolicy.AUTHORIZATION) && !PolicyUtil.isProvided((Exchange)exchange, (Policy)SecurityPolicy.AUTHORIZATION) && this.isAuthorizationProvided(serviceSecurity, securityContext)) {
            PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.AUTHORIZATION);
        }
        this._securityContextManager.setContext(exchange, securityContext);
    }

    private void cleanup(Exchange exchange, ServiceSecurity serviceSecurity) {
        int pc = SecurityHandler.processCount().decrementAndGet();
        if (pc < 1) {
            this._securityContextManager.setContext(exchange, null);
            SecurityHandler.processCount().set(0);
        }
    }

    private boolean isConfidentialityProvided(SecurityContext securityContext) {
        Set creds = securityContext.getCredentials(ConfidentialityCredential.class);
        for (ConfidentialityCredential cred : creds) {
            if (!cred.isConfidential()) continue;
            return true;
        }
        return false;
    }

    private boolean isClientAuthenticationProvided(SecurityContext securityContext) {
        Set creds = securityContext.getCredentials(PrincipalCredential.class);
        for (PrincipalCredential cred : creds) {
            if (cred.getPrincipal() == null || !cred.isTrusted()) continue;
            return true;
        }
        return false;
    }

    private boolean isAuthorizationProvided(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        return this._securityProvider.checkRolesAllowed(serviceSecurity, securityContext);
    }

    private static synchronized AtomicInteger processCount() {
        AtomicInteger hic = PROCESS_COUNT.get();
        if (hic == null) {
            hic = new AtomicInteger(0);
            PROCESS_COUNT.set(hic);
        }
        return hic;
    }

    public static enum SecurityAction {
        PROCESS,
        CLEANUP;

    }
}

