/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.switchyard.handlers.MockTransaction;

class MockTransactionManager
implements TransactionManager {
    private ThreadLocal<MockTransaction> transaction = new ThreadLocal();

    MockTransactionManager() {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transaction.set(new MockTransaction());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.transaction.get().commit();
        this.transaction.remove();
    }

    public int getStatus() throws SystemException {
        if (this.transaction.get() != null) {
            return this.transaction.get().getStatus();
        }
        return 6;
    }

    public MockTransaction getTransaction() throws SystemException {
        return this.transaction.get();
    }

    public void resume(Transaction arg0) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.transaction.set((MockTransaction)MockTransaction.class.cast(arg0));
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transaction.get().rollback();
        this.transaction.remove();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transaction.get().setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        MockTransaction t = this.transaction.get();
        this.transaction.remove();
        return t;
    }
}

