/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.internal.transform.BaseTransformResolver;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class BaseTransformResolverTest {
    private static final QName A = new QName("a");
    private static final QName B = new QName("b");
    private static final QName C = new QName("c");
    private static final QName D = new QName("d");
    private static final QName E = new QName("e");
    private Transformer<?, ?> fromAtoB = this.createTransformer(A, B);
    private Transformer<?, ?> fromBtoC = this.createTransformer(B, C);
    private Transformer<?, ?> fromBtoE;
    private Transformer<?, ?> fromCtoD = this.createTransformer(C, D);
    private BaseTransformResolver resolver;
    private BaseTransformerRegistry registry;

    public BaseTransformResolverTest() {
        this.fromBtoE = this.createTransformer(B, E);
    }

    @Before
    public void setUp() throws Exception {
        this.registry = new BaseTransformerRegistry();
        this.resolver = new BaseTransformResolver((TransformerRegistry)this.registry);
    }

    @Test
    public void AtoCwithTwoHops() {
        this.registry.addTransformer(this.fromAtoB);
        this.registry.addTransformer(this.fromBtoC);
        this.registry.addTransformer(this.fromBtoE);
        LinkedList list = new LinkedList();
        boolean resolved = this.resolver.resolvePath(list, A, C, 2);
        Assert.assertTrue((boolean)resolved);
        Assert.assertEquals((Object)B, list.pop());
        Assert.assertEquals((Object)C, list.pop());
    }

    @Test
    public void AtoCwithOneHop() {
        this.registry.addTransformer(this.fromAtoB);
        this.registry.addTransformer(this.fromBtoC);
        LinkedList list = new LinkedList();
        boolean resolved = this.resolver.resolvePath(list, A, C, 1);
        Assert.assertFalse((boolean)resolved);
    }

    @Test
    public void AtoDwithThreeHop() {
        this.registry.addTransformer(this.fromAtoB);
        this.registry.addTransformer(this.fromBtoC);
        this.registry.addTransformer(this.fromCtoD);
        LinkedList list = new LinkedList();
        boolean resolved = this.resolver.resolvePath(list, A, D, 3);
        Assert.assertTrue((boolean)resolved);
        Assert.assertEquals((Object)B, list.pop());
        Assert.assertEquals((Object)C, list.pop());
        Assert.assertEquals((Object)D, list.pop());
    }

    @Test
    public void AtoBwithOneHop() {
        this.registry.addTransformer(this.fromAtoB);
        LinkedList list = new LinkedList();
        boolean resolved = this.resolver.resolvePath(list, A, B, 1);
        Assert.assertTrue((boolean)resolved);
        Assert.assertEquals((Object)B, list.pop());
    }

    @Test
    public void AtoEwithCycleAtoA() {
        this.registry.addTransformer(this.fromAtoB);
        this.registry.addTransformer(this.createTransformer(A, A));
        this.registry.addTransformer(this.createTransformer(B, A));
        LinkedList list = new LinkedList();
        boolean resolved = this.resolver.resolvePath(list, A, E, 2);
        Assert.assertFalse((boolean)resolved);
    }

    Transformer createTransformer(QName from, QName to) {
        return new BaseTransformer(from, to){

            public Object transform(Object from) {
                return null;
            }
        };
    }
}

