/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.switchyard.transform.BaseTransformer;

public class BaseTransformerTest {
    @Test
    public void testGetName_default_with_generics() {
        BaseTransformer<Double, String> intToStr = new BaseTransformer<Double, String>(){

            public String transform(Double from) {
                return null;
            }
        };
        Assert.assertEquals((Object)"java:java.lang.Double", (Object)intToStr.getFrom().toString());
        Assert.assertEquals((Object)"java:java.lang.String", (Object)intToStr.getTo().toString());
    }

    @Test
    public void testGetName_default_without_generics() {
        BaseTransformer intToStr = new BaseTransformer(){

            public Object transform(Object from) {
                return null;
            }
        };
        Assert.assertEquals((Object)"java:java.lang.Object", (Object)intToStr.getFrom().toString());
        Assert.assertEquals((Object)"java:java.lang.Object", (Object)intToStr.getTo().toString());
    }

    @Test
    public void testGetName_specified_with_generics() {
        QName fromName = new QName("string1");
        QName toName = new QName("string2");
        BaseTransformer<String, String> intToStr = new BaseTransformer<String, String>(fromName, toName){

            public String transform(String from) {
                return null;
            }
        };
        Assert.assertEquals((Object)fromName, (Object)intToStr.getFrom());
        Assert.assertEquals((Object)toName, (Object)intToStr.getTo());
    }

    @Test
    public void testGetName_specified_without_generics() {
        QName fromName = new QName("string1");
        QName toName = new QName("string2");
        BaseTransformer intToStr = new BaseTransformer(fromName, toName){

            public Object transform(Object from) {
                return null;
            }
        };
        Assert.assertEquals((Object)fromName, (Object)intToStr.getFrom());
        Assert.assertEquals((Object)toName, (Object)intToStr.getTo());
    }
}

