/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.ContextProperty;
import org.switchyard.internal.DefaultContext;
import org.switchyard.serial.CompressionType;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public final class ContextSerializationTest {
    @Test
    public void testContextProperty() throws Exception {
        this.assertContextProperty(this.serDeser(this.buildContextProperty(), ContextProperty.class));
    }

    @Test
    public void testScopedPropertyMap() throws Exception {
        this.assertScopedPropertyMap(this.serDeser(this.buildScopedPropertyMap(), Map.class));
    }

    @Test
    public void testDefaultContext() throws Exception {
        this.assertDefaultContext(this.serDeser(this.buildDefaultContext(), DefaultContext.class));
    }

    private ContextProperty buildContextProperty() {
        ContextProperty cp = new ContextProperty("foo", Scope.EXCHANGE, (Object)"bar");
        cp.addLabels(new String[]{"baz", "whiz"});
        return cp;
    }

    private Map<String, Property> buildScopedPropertyMap() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        ContextProperty property = this.buildContextProperty();
        properties.put(property.getName(), (Property)property);
        return properties;
    }

    private DefaultContext buildDefaultContext() {
        return new DefaultContext(Scope.EXCHANGE, this.buildScopedPropertyMap());
    }

    private void assertContextProperty(ContextProperty cp) {
        Assert.assertNotNull((Object)cp);
        Assert.assertEquals((Object)"foo", (Object)cp.getName());
        Assert.assertSame((Object)Scope.EXCHANGE, (Object)cp.getScope());
        Assert.assertEquals((Object)"bar", (Object)cp.getValue());
        Set labels = cp.getLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("baz"));
        Assert.assertTrue((boolean)labels.contains("whiz"));
        Assert.assertFalse((boolean)labels.contains("beep"));
    }

    private void assertScopedPropertyMap(Map<String, Property> spm) {
        Assert.assertNotNull(spm);
        this.assertContextProperty((ContextProperty)spm.values().iterator().next());
    }

    private void assertDefaultContext(DefaultContext dc) {
        Assert.assertNotNull((Object)dc);
        this.assertContextProperty((ContextProperty)dc.getProperties().iterator().next());
    }

    private <T> T serDeser(T obj, Class<T> type) throws Exception {
        FormatType format = FormatType.JSON;
        CompressionType compression = null;
        Serializer ser = SerializerFactory.create((FormatType)format, compression, (boolean)true);
        byte[] bytes = ser.serialize(obj, type);
        return (T)ser.deserialize(bytes, type);
    }
}

