/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.internal.DefaultHandlerChain;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.HandlerChain;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.spi.Dispatcher;

public class DefaultHandlerChainTest {
    private HandlerChain _chain;

    @Before
    public void setUp() {
        this._chain = new DefaultHandlerChain();
    }

    @Test
    public void faultChainContinuesOnFault() throws Exception {
        BaseHandler badHandler = new BaseHandler(){

            public void handleFault(Exchange exchange) {
                throw new RuntimeException("oops!");
            }
        };
        MockHandler goodHandler = new MockHandler();
        this._chain.addFirst("first", (ExchangeHandler)badHandler);
        this._chain.addLast("second", (ExchangeHandler)goodHandler);
        MockDomain domain = new MockDomain();
        ServiceReference reference = domain.createInOnlyService(new QName("bar"));
        Dispatcher dispatch = domain.getBus().createDispatcher(reference);
        ExchangeImpl ex = new ExchangeImpl((ServiceDomain)domain, dispatch).consumer(reference, (ServiceOperation)new InOnlyOperation("foo"));
        this._chain.handleFault((Exchange)ex);
        Assert.assertNotNull((Object)((Object)goodHandler.waitForFaultMessage()));
    }

    @Test
    public void testReplace() {
        MockHandler m1 = new MockHandler();
        MockHandler m2 = new MockHandler();
        MockHandler m3 = new MockHandler();
        MockHandler m4 = new MockHandler();
        this._chain.addFirst("1", (ExchangeHandler)m1);
        Assert.assertFalse((boolean)this._chain.replace("5", (ExchangeHandler)m2));
        Assert.assertTrue((boolean)this._chain.replace("1", (ExchangeHandler)m2));
        Assert.assertTrue((boolean)this._chain.getHandlers().contains((Object)m2));
        Assert.assertFalse((boolean)this._chain.getHandlers().contains((Object)m1));
        this._chain.remove("1");
        Assert.assertEquals((long)0L, (long)this._chain.getHandlers().size());
        this._chain.addFirst("1", (ExchangeHandler)m1);
        this._chain.addFirst("2", (ExchangeHandler)m2);
        this._chain.addFirst("3", (ExchangeHandler)m3);
        this._chain.replace("2", (ExchangeHandler)m4);
        Assert.assertEquals((Object)((Object)m4), this._chain.getHandlers().get(1));
    }
}

