/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.internal.ExceptionToStringTransformer;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.runtime.event.ExchangeInitiatedEvent;
import org.switchyard.spi.Dispatcher;
import org.switchyard.transform.Transformer;

public class ExchangeImplTest {
    private MockDomain _domain;
    private Dispatcher _dispatch;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
        ServiceReference reference = this._domain.createInOnlyService(new QName("foo"));
        this._dispatch = this._domain.getBus().createDispatcher(reference);
    }

    @Test
    public void testSendFaultOnNewExchange() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain, this._dispatch);
        try {
            exchange.sendFault(exchange.createMessage());
            Assert.fail((String)"Sending a fault on a new exchange is not allowed");
        }
        catch (IllegalStateException illEx) {
            return;
        }
    }

    @Test
    public void testPhaseIsNullOnNewExchange() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain, this._dispatch);
        Assert.assertNull((Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsInAfterInputMessage() {
        ServiceReference service = this._domain.createInOnlyService(new QName("InPhase"));
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertEquals((Object)ExchangePhase.IN, (Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsOutAfterOutputMessage() {
        MockHandler replyHandler = new MockHandler();
        ServiceReference service = this._domain.createInOutService(new QName("OutPhase"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        exchange.send(exchange.createMessage());
        replyHandler.waitForOKMessage();
        Assert.assertEquals((Object)ExchangePhase.OUT, (Object)exchange.getPhase());
    }

    @Test
    public void testPhaseIsOutAfterFaultMessage() {
        MockHandler replyHandler = new MockHandler();
        ServiceReference service = this._domain.createInOutService(new QName("FaultPhase"), (ExchangeHandler)new MockHandler().forwardInToFault());
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        exchange.send(exchange.createMessage());
        replyHandler.waitForFaultMessage();
        Assert.assertEquals((Object)ExchangePhase.OUT, (Object)exchange.getPhase());
    }

    @Test
    public void testMessageIdSetOnSend() {
        ServiceReference service = this._domain.createInOnlyService(new QName("IdTest"));
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertNotNull((Object)exchange.getMessage().getContext().getProperty("org.switchyard.messageId"));
    }

    @Test
    public void testRelatesToSetOnReply() {
        ServiceReference service = this._domain.createInOutService(new QName("ReplyTest"), (ExchangeHandler)new MockHandler().forwardInToOut());
        MockHandler replyHandler = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)replyHandler);
        Message message = exchange.createMessage();
        exchange.send(message);
        String requestId = (String)message.getContext().getPropertyValue("org.switchyard.messageId");
        String replyId = (String)exchange.getMessage().getContext().getPropertyValue("org.switchyard.messageId");
        String replyRelatesTo = (String)exchange.getMessage().getContext().getPropertyValue("org.switchyard.relatesTo");
        Assert.assertEquals((Object)requestId, (Object)replyRelatesTo);
        Assert.assertFalse((boolean)requestId.equals(replyId));
    }

    @Test
    public void testNullSend() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain, this._dispatch);
        try {
            exchange.send(null);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            boolean messageMatch = e.getMessage().contains("SWITCHYARD014019");
            Assert.assertTrue((boolean)messageMatch);
        }
    }

    @Test
    public void testNullSendFault() {
        ExchangeImpl exchange = new ExchangeImpl((ServiceDomain)this._domain, this._dispatch);
        try {
            exchange.sendFault(null);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            boolean messageMatch = e.getMessage().contains("SWITCHYARD014019");
            Assert.assertTrue((boolean)messageMatch);
        }
    }

    @Test
    public void testExchangeInitiatedEvent() {
        EventCounter counter = new EventCounter();
        this._domain.addEventObserver(counter, ExchangeInitiatedEvent.class);
        ServiceReference inOnlyService = this._domain.createInOnlyService(new QName("ExchangeInitiatedEvent-1"));
        Exchange inOnly = inOnlyService.createExchange();
        inOnly.send(inOnly.createMessage());
        Assert.assertEquals((long)1L, (long)counter.initiatedCount);
        counter.initiatedCount = 0;
        ServiceReference inOutService = this._domain.createInOutService(new QName("ExchangeInitiatedEvent-2"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange inOut = inOutService.createExchange((ExchangeHandler)new MockHandler());
        inOut.send(inOut.createMessage());
        Assert.assertEquals((long)1L, (long)counter.initiatedCount);
    }

    @Test
    public void testExchangeCompletedEvent() {
        EventCounter counter = new EventCounter();
        this._domain.addEventObserver(counter, ExchangeCompletionEvent.class);
        ServiceReference inOnlyService = this._domain.createInOnlyService(new QName("ExchangeCompleteEvent-1"));
        Exchange inOnly = inOnlyService.createExchange();
        inOnly.send(inOnly.createMessage());
        Assert.assertEquals((long)1L, (long)counter.completedCount);
        counter.completedCount = 0;
        ServiceReference inOutService = this._domain.createInOutService(new QName("ExchangeCompleteEvent-2"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange inOut = inOutService.createExchange((ExchangeHandler)new MockHandler());
        inOut.send(inOut.createMessage());
        Assert.assertEquals((long)1L, (long)counter.completedCount);
    }

    @Test
    public void testAllExchangeEventsReceived() throws Exception {
        int i;
        EventCounter counter = new EventCounter();
        this._domain.addEventObserver(counter, ExchangeInitiatedEvent.class);
        this._domain.addEventObserver(counter, ExchangeCompletionEvent.class);
        for (i = 0; i < 10; ++i) {
            ServiceReference inOnlyService = this._domain.createInOnlyService(new QName("ExchangeEvent-0" + i));
            Exchange inOnly = inOnlyService.createExchange();
            inOnly.send(inOnly.createMessage());
        }
        Assert.assertEquals((long)10L, (long)counter.initiatedCount);
        Assert.assertEquals((long)10L, (long)counter.completedCount);
        counter.initiatedCount = 0;
        counter.completedCount = 0;
        for (i = 0; i < 10; ++i) {
            ServiceReference inOutService = this._domain.createInOutService(new QName("ExchangeEvent-1" + i), (ExchangeHandler)new MockHandler().forwardInToOut());
            Exchange inOut = inOutService.createExchange((ExchangeHandler)new MockHandler());
            inOut.send(inOut.createMessage());
        }
        Assert.assertEquals((long)10L, (long)counter.initiatedCount);
        Assert.assertEquals((long)10L, (long)counter.completedCount);
    }

    @Test
    public void testGetMessage() throws Exception {
        QName serviceName = new QName("bleh");
        String inMsgContent = "in message";
        String outMsgContent = "out message";
        BaseHandler provider = new BaseHandler(){

            public void handleMessage(Exchange exchange) {
                Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"in message");
                Message outMsg = exchange.createMessage();
                outMsg.setContent((Object)"out message");
                try {
                    exchange.send(outMsg);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.toString());
                }
            }
        };
        BaseHandler consumer = new BaseHandler(){

            public void handleMessage(Exchange exchange) {
                Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"out message");
            }
        };
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange((ExchangeHandler)consumer);
        Message inMsg = exchange.createMessage();
        inMsg.setContent((Object)"in message");
        exchange.send(inMsg);
    }

    @Test
    public void testExceptionOnSendOnFaultExchange() throws Exception {
        QName serviceName = new QName("testExceptionOnSendOnFaultExchange");
        MockHandler provider = new MockHandler().forwardInToFault();
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        MockHandler consumer = new MockHandler();
        Exchange exchange = service.createExchange((ExchangeHandler)consumer);
        exchange.send(exchange.createMessage());
        provider.waitForOKMessage();
        consumer.waitForFaultMessage();
        try {
            exchange.send(exchange.createMessage());
        }
        catch (IllegalStateException e) {
            boolean messageMatch = e.getMessage().contains("SWITCHYARD014020");
            Assert.assertTrue((boolean)messageMatch);
        }
    }

    @Test
    public void testExceptionOnNoConsumerOnInOut() throws Exception {
        QName serviceName = new QName("testNoNPEOnNoConsumer");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("explode");
            }
        };
        ServiceReference service = this._domain.createInOutService(serviceName, (ExchangeHandler)provider);
        try {
            service.createExchange();
            Assert.fail((String)"Should not be able to create an InOut without specifying a reply handler");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testNoNPEOnInOnlyFault() throws Exception {
        QName serviceName = new QName("testNoNPEOnNoConsumer");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("explode");
            }
        };
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
    }

    @Test
    public void testFaultWithNoHandler() throws Exception {
        QName serviceName = new QName("testFaultWithNoHandler");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                throw new HandlerException("Fault With No Handler!");
            }
        };
        ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)provider);
        Exchange exchange = service.createExchange();
        exchange.send(exchange.createMessage());
        Assert.assertEquals((Object)ExchangeState.FAULT, (Object)exchange.getState());
    }

    @Test
    public void testFaultTransformSequence() throws Exception {
        QName serviceName = new QName("testFaultTransformSequence");
        MockHandler provider = new MockHandler(){

            @Override
            public void handleMessage(Exchange exchange) throws HandlerException {
                Message fault = exchange.createMessage();
                fault.setContent((Object)new Exception("testFaultTransformSequence"));
                exchange.sendFault(fault);
            }
        };
        InOutOperation providerContract = new InOutOperation("faultOp", JavaTypes.toMessageType(String.class), JavaTypes.toMessageType(String.class), JavaTypes.toMessageType(Exception.class));
        InOutOperation consumerContract = new InOutOperation("faultOp", JavaTypes.toMessageType(String.class), JavaTypes.toMessageType(String.class), JavaTypes.toMessageType(String.class));
        this._domain.registerService(serviceName, (ServiceInterface)new InOutService(providerContract), (ExchangeHandler)provider);
        this._domain.getTransformerRegistry().addTransformer((Transformer)new ExceptionToStringTransformer());
        ServiceReference service = this._domain.registerServiceReference(serviceName, (ServiceInterface)new InOutService(consumerContract));
        Exchange exchange = service.createExchange((ExchangeHandler)new MockHandler());
        exchange.send(exchange.createMessage());
        Assert.assertEquals(String.class, exchange.getMessage().getContent().getClass());
        Assert.assertEquals((Object)exchange.getMessage().getContent(), (Object)"testFaultTransformSequence");
    }

    class EventCounter
    implements EventObserver {
        int initiatedCount;
        int completedCount;

        EventCounter() {
        }

        public void notify(EventObject event) {
            if (event instanceof ExchangeInitiatedEvent) {
                ++this.initiatedCount;
            } else if (event instanceof ExchangeCompletionEvent) {
                ++this.completedCount;
            }
        }
    }
}

