/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.switchyard.Message;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class TransformSequenceTest {
    @Test
    public void test() throws Exception {
        QName A2 = new QName("a");
        QName B2 = new QName("b");
        QName C2 = new QName("c");
        QName D2 = new QName("d");
        BaseTransformerRegistry xformReg = new BaseTransformerRegistry();
        TransformSequence transSequence = TransformSequence.from((QName)A2).to(B2).to(C2).to(D2);
        DefaultMessage message = new DefaultMessage().setContent((Object)A2);
        transSequence.apply((Message)message, (TransformerRegistry)xformReg);
        Assert.assertEquals((Object)A2, (Object)message.getContent());
        xformReg.addTransformer((Transformer)new MockTransformer(A2, B2));
        transSequence.apply((Message)message, (TransformerRegistry)xformReg);
        Assert.assertEquals((Object)B2, (Object)message.getContent());
        xformReg.addTransformer((Transformer)new MockTransformer(B2, C2)).addTransformer((Transformer)new MockTransformer(C2, D2));
        transSequence.apply((Message)message, (TransformerRegistry)xformReg);
        Assert.assertEquals((Object)D2, (Object)message.getContent());
    }

    private class MockTransformer
    extends BaseTransformer {
        private QName from;
        private QName to;

        private MockTransformer(QName from, QName to) {
            super(from, to);
            this.from = from;
            this.to = to;
        }

        public Object transform(Object from) {
            Assert.assertEquals((Object)this.from, (Object)from);
            return this.to;
        }
    }
}

