/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tests;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceReference;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.TransformationFailureException;
import org.switchyard.transform.Transformer;

public class IndirectTransformationTest {
    private MockDomain _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneLevelDeepTransformInProvider() throws Exception {
        QName serviceName = new QName("nameTransform");
        QName inType = new QName("fromA");
        QName indirectDestOutType = new QName("viaB");
        QName indirectDestInType = new QName("viaB");
        QName finalDestOutType = new QName("toC");
        String input = "Hello";
        BaseTransformer<String, String> transformAtoB = new BaseTransformer<String, String>(inType, indirectDestOutType){

            public String transform(String from) {
                return from + " there,";
            }
        };
        this._domain.getTransformerRegistry().addTransformer((Transformer)transformAtoB);
        BaseTransformer<String, String> transformBtoC = new BaseTransformer<String, String>(indirectDestInType, finalDestOutType){

            public String transform(String from) {
                return from + " SwitchYard";
            }
        };
        this._domain.getTransformerRegistry().addTransformer((Transformer)transformBtoC);
        try {
            TestTransformHandler serviceHandler = new TestTransformHandler();
            ServiceReference service = this._domain.createInOnlyService(serviceName, (ExchangeHandler)serviceHandler);
            MockHandler invokerHandler = new MockHandler();
            Exchange exchange = service.createExchange((ExchangeHandler)invokerHandler);
            Message msg = exchange.createMessage().setContent((Object)"Hello");
            TransformSequence.from((QName)inType).to(finalDestOutType).associateWith(msg);
            msg.setContent((Object)"Hello");
            exchange.send(msg);
            Assert.assertTrue((boolean)serviceHandler.isSuccess());
        }
        finally {
            this._domain.getTransformerRegistry().removeTransformer((Transformer)transformAtoB);
            this._domain.getTransformerRegistry().removeTransformer((Transformer)transformBtoC);
        }
    }

    private class TestTransformHandler
    extends TransformHandler {
        boolean success;

        private TestTransformHandler() {
            super(new Transformer[0]);
            this.success = false;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void handleMessage(Exchange exchange) throws TransformationFailureException {
            String content = (String)exchange.getMessage().getContent();
            if (content.equals("Hello there, SwitchYard")) {
                this.success = true;
            }
        }
    }
}

