/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.jboss.provider;

import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.MappingResult;
import org.picketlink.identity.federation.bindings.jboss.auth.mapping.STSGroupMappingProvider;
import org.picketlink.identity.federation.bindings.jboss.auth.mapping.STSPrincipalMappingProvider;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.credential.AssertionCredential;
import org.switchyard.security.jboss.JBossSecurityLogger;
import org.switchyard.security.principal.GroupPrincipal;
import org.switchyard.security.principal.RolePrincipal;
import org.switchyard.security.principal.UserPrincipal;
import org.switchyard.security.provider.JaasSecurityProvider;
import org.w3c.dom.Element;

public class JBossJaasSecurityProvider
extends JaasSecurityProvider {
    public boolean propagate(ServiceSecurity serviceSecurity, org.switchyard.security.context.SecurityContext securityContext) {
        String sy_securityDomain = serviceSecurity.getSecurityDomain();
        Subject sy_subject = securityContext.getSubject(sy_securityDomain);
        SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
        if (jb_securityContext != null) {
            String jb_securityDomain = jb_securityContext.getSecurityDomain();
            if (sy_securityDomain.equals(jb_securityDomain)) {
                Subject jb_subject = jb_securityContext.getUtil().getSubject();
                this.transfer(jb_subject, sy_subject);
                return true;
            }
        } else {
            Set assertionCredentials = securityContext.getCredentials(AssertionCredential.class);
            for (AssertionCredential assertionCredential : assertionCredentials) {
                Element assertionElement = assertionCredential.getAssertion();
                if (assertionElement == null) continue;
                Subject sts_subject = new Subject();
                boolean sts_mapped = false;
                HashMap<String, Element> contextMap = new HashMap<String, Element>();
                contextMap.put("org.picketlink.identity.federation.core.wstrust.lm.stsToken", assertionElement);
                STSPrincipalMappingProvider principalMapper = new STSPrincipalMappingProvider();
                principalMapper.init(contextMap);
                MappingResult principalResult = new MappingResult();
                principalMapper.setMappingResult(principalResult);
                principalMapper.performMapping(contextMap, null);
                Principal principal = (Principal)principalResult.getMappedObject();
                if (principal != null) {
                    sts_subject.getPrincipals().add((Principal)new UserPrincipal(principal.getName()));
                    sts_mapped = true;
                }
                STSGroupMappingProvider rolesMapper = new STSGroupMappingProvider();
                rolesMapper.init(contextMap);
                MappingResult rolesResult = new MappingResult();
                rolesMapper.setMappingResult(rolesResult);
                rolesMapper.performMapping(contextMap, null);
                RoleGroup roleGroup = (RoleGroup)rolesResult.getMappedObject();
                if (roleGroup != null) {
                    GroupPrincipal roles = null;
                    for (Role role : roleGroup.getRoles()) {
                        if (roles == null) {
                            roles = new GroupPrincipal("Roles");
                        }
                        roles.addMember((Principal)new RolePrincipal(role.getRoleName()));
                    }
                    if (roles != null) {
                        sts_subject.getPrincipals().add((Principal)roles);
                        sts_mapped = true;
                    }
                }
                if (!sts_mapped) continue;
                this.transfer(sts_subject, sy_subject);
                return true;
            }
        }
        return super.propagate(serviceSecurity, securityContext);
    }

    public boolean clear(ServiceSecurity serviceSecurity, org.switchyard.security.context.SecurityContext securityContext) {
        boolean success = super.clear(serviceSecurity, securityContext);
        try {
            String jb_securityDomain;
            String sy_securityDomain;
            SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
            if (jb_securityContext != null && (sy_securityDomain = serviceSecurity.getSecurityDomain()).equals(jb_securityDomain = jb_securityContext.getSecurityDomain())) {
                SecurityContextAssociation.clearSecurityContext();
            }
        }
        catch (Throwable t) {
            JBossSecurityLogger.ROOT_LOGGER.clearSecurityContextAssociation(t);
            success = false;
        }
        return success;
    }

    static {
        SecurityContextAssociation.getSecurityContext();
    }
}

