/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import org.switchyard.Exchange;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.ServiceSecurity;

public final class SecurityMetadata {
    private final Source _source;
    private final ServiceDomain _serviceDomain;
    private final ServiceSecurity _serviceSecurity;

    private SecurityMetadata(Source source, ServiceDomain serviceDomain, ServiceSecurity serviceSecurity) {
        this._source = source;
        this._serviceDomain = serviceDomain;
        this._serviceSecurity = serviceSecurity;
    }

    public boolean isProvider() {
        return this._source == Source.PROVIDER;
    }

    public boolean isConsumer() {
        return this._source == Source.CONSUMER;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    public ServiceSecurity getServiceSecurity() {
        return this._serviceSecurity;
    }

    public static final ServiceDomain getServiceDomain(Exchange exchange) {
        return SecurityMetadata.getSecurityMetadata(exchange).getServiceDomain();
    }

    public static final ServiceSecurity getServiceSecurity(Exchange exchange) {
        return SecurityMetadata.getSecurityMetadata(exchange).getServiceSecurity();
    }

    public static final SecurityMetadata getSecurityMetadata(Exchange exchange) {
        ServiceReference serviceReference;
        Source source = null;
        ServiceDomain serviceDomain = null;
        ServiceSecurity serviceSecurity = null;
        Service service = exchange.getProvider();
        if (service != null) {
            source = Source.PROVIDER;
            serviceDomain = service.getDomain();
            serviceSecurity = service.getServiceMetadata().getSecurity();
        }
        if (serviceSecurity == null && (serviceReference = exchange.getConsumer()) != null) {
            source = Source.CONSUMER;
            serviceDomain = serviceReference.getDomain();
            serviceSecurity = serviceReference.getServiceMetadata().getSecurity();
        }
        return new SecurityMetadata(source, serviceDomain, serviceSecurity);
    }

    private static enum Source {
        PROVIDER,
        CONSUMER;

    }
}

