/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.protostuff.format;

import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.BaseSerializer;
import org.switchyard.serial.FormatType;

public abstract class BaseProtostuffSerializer
extends BaseSerializer {
    protected BaseProtostuffSerializer(FormatType format) {
        super(format);
    }

    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream((OutputStream)new BufferedOutputStream(out, this.getBufferSize()));
        Schema schema = RuntimeSchema.getSchema(type);
        this.writeTo(out, obj, schema);
        return ((CountingOutputStream)out).getCount();
    }

    public abstract <T> void writeTo(OutputStream var1, T var2, Schema<T> var3) throws IOException;

    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        in = new BufferedInputStream(in, this.getBufferSize());
        Object obj = Construction.construct(type);
        Schema schema = RuntimeSchema.getSchema(type);
        this.mergeFrom(in, obj, schema);
        return (T)obj;
    }

    public abstract <T> void mergeFrom(InputStream var1, T var2, Schema<T> var3) throws IOException;
}

