/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.protostuff.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.protostuff.format.GraphProtostuffSerializer;
import org.switchyard.serial.protostuff.format.JSONProtostuffSerializer;
import org.switchyard.serial.protostuff.format.NativeProtostuffSerializer;
import org.switchyard.serial.protostuff.format.NumericJSONProtostuffSerializer;
import org.switchyard.serial.protostuff.format.ProtobufProtostuffSerializer;
import org.switchyard.serial.protostuff.format.XMLProtostuffSerializer;
import org.switchyard.serial.spi.SerializationProvider;

public class ProtostuffSerializationProvider
extends SerializationProvider {
    private static final Map<FormatType, Class<? extends Serializer>> MAP;

    public Set<FormatType> getSupportedFormats() {
        return MAP.keySet();
    }

    public Serializer newSerializer(FormatType format) {
        Class<? extends Serializer> c = MAP.get(format);
        return c != null ? (Serializer)Construction.construct(c) : null;
    }

    static {
        LinkedHashMap<FormatType, Class> map = new LinkedHashMap<FormatType, Class>();
        map.put(FormatType.GRAPH_PROTOSTUFF, GraphProtostuffSerializer.class);
        map.put(FormatType.JSON, JSONProtostuffSerializer.class);
        map.put(FormatType.JSON_NUMERIC, NumericJSONProtostuffSerializer.class);
        map.put(FormatType.NATIVE_PROTOSTUFF, NativeProtostuffSerializer.class);
        map.put(FormatType.PROTOBUF, ProtobufProtostuffSerializer.class);
        map.put(FormatType.XML_PROTOSTUFF, XMLProtostuffSerializer.class);
        MAP = Collections.unmodifiableMap(map);
    }
}

