/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.Access;
import org.switchyard.common.type.reflect.BeanAccess;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.CoverageType;
import org.switchyard.serial.graph.Exclude;
import org.switchyard.serial.graph.Factory;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.Include;
import org.switchyard.serial.graph.Strategy;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.NodeBuilder;

public final class AccessNode
implements Node {
    private String _type;
    private Map<String, Integer> _ids;
    private transient Set<Integer> _resolutions;

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public Map<String, Integer> getIds() {
        return this._ids;
    }

    public void setIds(Map<String, Integer> ids) {
        this._ids = ids;
    }

    @Override
    public void compose(Object obj, Graph graph) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            this.setType(clazz.getName());
            for (Access access : this.getAccessList(clazz)) {
                Integer id;
                Object value;
                if (!(access instanceof FieldAccess) && !access.isWriteable() || (value = access.read(obj)) == null) continue;
                if (this._ids == null) {
                    this._ids = new LinkedHashMap<String, Integer>();
                }
                if ((id = NodeBuilder.build(value, graph)) == null) continue;
                this._ids.put(access.getName(), id);
            }
        }
    }

    @Override
    public Object decompose(final Graph graph) {
        Object obj;
        if (this._type == null) {
            return null;
        }
        Class clazz = Classes.forName((String)this._type, this.getClass());
        Factory factory = Factory.getFactory(clazz);
        Object v0 = obj = factory.supports(clazz) ? factory.create(clazz) : null;
        if (obj != null && this._ids != null) {
            for (final Access access : this.getAccessList(clazz)) {
                final Integer id = this._ids.get(access.getName());
                if (id == null) continue;
                if (this._resolutions == null) {
                    this._resolutions = new HashSet<Integer>();
                }
                if (this._resolutions.contains(id)) continue;
                this._resolutions.add(id);
                graph.addResolution(new Runnable(){

                    @Override
                    public void run() {
                        Object[] value = graph.decomposeReference(id);
                        if (value != null) {
                            boolean skip = !access.isWriteable();
                            Class accessType = access.getType();
                            if (access instanceof FieldAccess) {
                                if (NodeBuilder.isCollection(accessType) && value instanceof Collection) {
                                    ((Collection)access.read(obj)).addAll((Collection)value);
                                    skip = true;
                                } else if (NodeBuilder.isMap(accessType) && value instanceof Map) {
                                    ((Map)access.read(obj)).putAll((Map)value);
                                    skip = true;
                                }
                            }
                            if (!skip) {
                                if (NodeBuilder.isArray(accessType) && value.getClass().isArray()) {
                                    Object[] old_array = value;
                                    Object[] new_array = (Object[])Array.newInstance(accessType.getComponentType(), old_array.length);
                                    System.arraycopy(old_array, 0, new_array, 0, old_array.length);
                                    value = new_array;
                                }
                                access.write(obj, (Object)value);
                            }
                        }
                    }
                });
            }
        }
        return obj;
    }

    private List<Access> getAccessList(Class<?> clazz) {
        ArrayList<Access> accessList = new ArrayList<Access>();
        if (clazz.getAnnotation(Deprecated.class) != null) {
            return accessList;
        }
        Strategy strategy = clazz.getAnnotation(Strategy.class);
        AccessType accessType = strategy != null ? strategy.access() : AccessType.BEAN;
        CoverageType coverageType = strategy != null ? strategy.coverage() : CoverageType.INCLUSIVE;
        switch (accessType) {
            case BEAN: {
                BeanInfo info;
                try {
                    info = Introspector.getBeanInfo(clazz);
                }
                catch (IntrospectionException ie) {
                    throw new RuntimeException(ie);
                }
                for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                    BeanAccess access;
                    Method method = desc.getReadMethod();
                    if ((!CoverageType.INCLUSIVE.equals((Object)coverageType) || method.getAnnotation(Exclude.class) != null) && (!CoverageType.EXCLUSIVE.equals((Object)coverageType) || method.getAnnotation(Include.class) == null) || method.getAnnotation(Deprecated.class) != null || !(access = new BeanAccess(desc)).isReadable() || "class".equals(access.getName())) continue;
                    accessList.add((Access)access);
                }
                break;
            }
            case FIELD: {
                for (Field field : clazz.getDeclaredFields()) {
                    FieldAccess access;
                    if ((!CoverageType.INCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Exclude.class) != null) && (!CoverageType.EXCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Include.class) == null) || field.getAnnotation(Deprecated.class) != null || Modifier.isTransient(field.getModifiers()) || !(access = new FieldAccess(field)).isReadable()) continue;
                    accessList.add((Access)access);
                }
                break;
            }
        }
        return accessList;
    }
}

