/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.lang.reflect.Constructor;
import org.switchyard.HandlerException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.NodeBuilder;

public final class ThrowableNode
implements Node {
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{String.class}, new Class[0]};
    private Integer _clazz;
    private String _message;
    private Integer _cause;
    private Integer _stackTrace;
    private Boolean _wrapper;

    public Integer getClazz() {
        return this._clazz;
    }

    public void setClazz(Integer clazz) {
        this._clazz = clazz;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public Integer getCause() {
        return this._cause;
    }

    public void setCause(Integer cause) {
        this._cause = cause;
    }

    public Integer getStackTrace() {
        return this._stackTrace;
    }

    public void setStackTrace(Integer stackTrace) {
        this._stackTrace = stackTrace;
    }

    public Boolean getWrapper() {
        return this._wrapper;
    }

    public void setWrapper(Boolean wrapper) {
        this._wrapper = wrapper;
    }

    @Override
    public void compose(Object obj, Graph graph) {
        Throwable throwable = (Throwable)obj;
        this.setClazz(NodeBuilder.build(throwable.getClass(), graph));
        this.setMessage(throwable.getMessage());
        this.setCause(NodeBuilder.build(throwable.getCause(), graph));
        this.setStackTrace(NodeBuilder.build(throwable.getStackTrace(), graph));
        if (throwable instanceof HandlerException) {
            this.setWrapper(((HandlerException)throwable).isWrapper());
        }
    }

    @Override
    public Object decompose(Graph graph) {
        Object[] array;
        Class clazz = (Class)graph.decomposeReference(this.getClazz());
        Throwable throwable = this.newThrowable(clazz, this.getMessage());
        Throwable cause = (Throwable)graph.decomposeReference(this.getCause());
        if (cause != null) {
            throwable.initCause(cause);
        }
        if ((array = (Object[])graph.decomposeReference(this.getStackTrace())) != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[array.length];
            for (int i = 0; i < array.length; ++i) {
                stackTrace[i] = (StackTraceElement)array[i];
            }
            throwable.setStackTrace(stackTrace);
        }
        if (throwable instanceof HandlerException && this.getWrapper() != null) {
            new FieldAccess(HandlerException.class, "_wrapper").write((Object)throwable, (Object)this.getWrapper());
        }
        return throwable;
    }

    private Throwable newThrowable(Class<? extends Throwable> throwableClass, String message) {
        Throwable throwable = null;
        Constructor<? extends Throwable> constructor = this.getConstructor(throwableClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                throwable = (Throwable)Construction.construct(throwableClass);
            } else if (parameterTypes.length == 1) {
                throwable = (Throwable)Construction.construct(throwableClass, (Class[])parameterTypes, (Object[])new Object[]{message});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate Throwable class: " + throwableClass.getName());
        }
        return throwable;
    }

    private Constructor<? extends Throwable> getConstructor(Class<? extends Throwable> throwableClass) {
        Constructor<? extends Throwable> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = throwableClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }
}

