/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.switchyard.serial.graph.Factory;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.node.AccessNode;
import org.switchyard.serial.graph.node.ArrayNode;
import org.switchyard.serial.graph.node.ClassNode;
import org.switchyard.serial.graph.node.CollectionNode;
import org.switchyard.serial.graph.node.DOMNode;
import org.switchyard.serial.graph.node.DataSourceNode;
import org.switchyard.serial.graph.node.InputStreamNode;
import org.switchyard.serial.graph.node.MapNode;
import org.switchyard.serial.graph.node.NoopNode;
import org.switchyard.serial.graph.node.QNameNode;
import org.switchyard.serial.graph.node.StackTraceElementNode;
import org.switchyard.serial.graph.node.ThrowableNode;
import org.switchyard.serial.graph.node.UUIDNode;
import org.w3c.dom.Node;

public final class NodeBuilder {
    private static final Class<?>[] SIMPLE_TYPES = new Class[]{Boolean.class, Calendar.class, Character.class, CharSequence.class, Date.class, Number.class};

    public static Integer build(Object obj, Graph graph) {
        Integer id = graph.id(obj);
        if (id == 0 || graph.getReference(id) != null) {
            return id;
        }
        Class<?> clazz = obj.getClass();
        if (NodeBuilder.isSimple(clazz)) {
            graph.putReference(id, obj);
        } else if (NodeBuilder.isArray(clazz)) {
            if (NodeBuilder.isSimple(clazz.getComponentType())) {
                graph.putReference(id, obj);
            } else {
                ArrayNode node = new ArrayNode();
                graph.putReference(id, node);
                node.compose(obj, graph);
            }
        } else if (NodeBuilder.isClass(clazz)) {
            ClassNode node = new ClassNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isCollection(clazz)) {
            CollectionNode node = new CollectionNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isMap(clazz)) {
            MapNode node = new MapNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isDOM(clazz)) {
            DOMNode node = new DOMNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isQName(clazz)) {
            QNameNode node = new QNameNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isDataSource(clazz)) {
            DataSourceNode node = new DataSourceNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isInputStream(clazz)) {
            InputStreamNode node = new InputStreamNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isUUID(clazz)) {
            UUIDNode node = new UUIDNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isThrowable(clazz)) {
            ThrowableNode node = new ThrowableNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isStackTraceElement(clazz)) {
            StackTraceElementNode node = new StackTraceElementNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else if (NodeBuilder.isAccessible(clazz)) {
            AccessNode node = new AccessNode();
            graph.putReference(id, node);
            node.compose(obj, graph);
        } else {
            graph.putReference(id, NoopNode.INSTANCE);
        }
        return id;
    }

    static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    static boolean isClass(Class<?> clazz) {
        return Class.class.isAssignableFrom(clazz);
    }

    static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    static boolean isDataSource(Class<?> clazz) {
        return DataSource.class.isAssignableFrom(clazz);
    }

    static boolean isDOM(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz);
    }

    static boolean isInputStream(Class<?> clazz) {
        return InputStream.class.isAssignableFrom(clazz);
    }

    static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    static boolean isQName(Class<?> clazz) {
        return QName.class.isAssignableFrom(clazz);
    }

    static boolean isSimple(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isEnum()) {
            return true;
        }
        for (Class<?> st : SIMPLE_TYPES) {
            if (!st.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static boolean isStackTraceElement(Class<?> clazz) {
        return StackTraceElement.class.isAssignableFrom(clazz);
    }

    static boolean isThrowable(Class<?> clazz) {
        return Throwable.class.isAssignableFrom(clazz);
    }

    static boolean isUUID(Class<?> clazz) {
        return UUID.class.isAssignableFrom(clazz);
    }

    static boolean isAccessible(Class<?> clazz) {
        return Factory.getFactory(clazz).supports(clazz);
    }

    private NodeBuilder() {
    }
}

