/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial;

import org.switchyard.serial.CompressionType;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.compress.GZIPSerializer;
import org.switchyard.serial.compress.ZIPSerializer;
import org.switchyard.serial.graph.GraphSerializer;
import org.switchyard.serial.spi.SerializationProvider;

public final class SerializerFactory {
    public static final Serializer create() {
        return SerializerFactory.create(FormatType.SER_OBJECT);
    }

    public static final Serializer create(FormatType format) {
        return SerializerFactory.create(format, null);
    }

    public static final Serializer create(FormatType format, CompressionType compression) {
        return SerializerFactory.create(format, compression, false);
    }

    public static final Serializer create(FormatType format, CompressionType compression, boolean graph) {
        Serializer serializer = null;
        SerializationProvider provider = SerializationProvider.getPrimaryProvider(format);
        if (provider != null) {
            serializer = provider.newSerializer(format);
            if (graph) {
                serializer = new GraphSerializer(serializer);
            }
            if (compression != null) {
                if (CompressionType.GZIP.equals((Object)compression)) {
                    serializer = new GZIPSerializer(serializer);
                } else if (CompressionType.ZIP.equals((Object)compression)) {
                    serializer = new ZIPSerializer(serializer);
                }
            }
        }
        return serializer;
    }

    private SerializerFactory() {
    }
}

