/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.SystemEventListener;
import org.drools.agent.impl.DoNothingSystemEventListener;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;
import org.junit.Assert;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class BPMMixIn
extends AbstractTestMixIn {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 9123;
    public static final String ADMINISTRATOR = "Administrator";
    private String _host = "127.0.0.1";
    private int _port = 9123;
    private TaskServer _server = null;
    private TaskClient _client = null;
    private boolean _clientConnected = false;
    private boolean _managedLifeCycle;

    public BPMMixIn() {
        this(true);
    }

    public BPMMixIn(boolean managedLifeCycle) {
        this._managedLifeCycle = managedLifeCycle;
    }

    public BPMMixIn setHost(String host) {
        this._host = host;
        return this;
    }

    public BPMMixIn setPort(int port) {
        this._port = port;
        return this;
    }

    @Override
    public void initialize() {
        if (this._managedLifeCycle && !this.startTaskServer("krisv", "johnd")) {
            Assert.fail((String)"Failed to autostart BPM TaskServer instance.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninitialize() {
        if (this._managedLifeCycle) {
            try {
                boolean keepWorking = true;
                while (keepWorking) {
                    try {
                        keepWorking = this.completeTasksForUsers("krisv", "johnd");
                    }
                    catch (Exception e) {
                        Assert.fail((String)"Failed to auto complete tasks on BPM TaskServer instance.");
                    }
                }
            }
            finally {
                this.stopTaskServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTaskServer(String ... userIds) {
        try {
            boolean ready = false;
            while (!ready) {
                Socket socket = null;
                try {
                    socket = new Socket(this._host, this._port);
                    if (socket.isConnected()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    ready = true;
                }
                catch (SocketException se) {
                    ready = true;
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                    socket = null;
                }
            }
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
            TaskService taskService = new TaskService(emf, (SystemEventListener)new DoNothingSystemEventListener());
            TaskServiceSession taskServiceSession = taskService.createSession();
            taskServiceSession.addUser(new User(ADMINISTRATOR));
            for (String userId : userIds) {
                if (ADMINISTRATOR.equals(userId)) continue;
                taskServiceSession.addUser(new User(userId));
            }
            for (String groupId : new String[]{"admin", "user", "developer"}) {
                taskServiceSession.addGroup(new Group(groupId));
            }
            taskServiceSession.dispose();
            this._server = new MinaTaskServer(taskService, this._port, this._host);
            new Thread((Runnable)this._server).start();
            return true;
        }
        catch (Throwable t) {
            StringWriter tsWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(tsWriter));
            Assert.fail((String)tsWriter.toString());
            return false;
        }
    }

    public void stopTaskServer() {
        if (this._server != null) {
            try {
                this._server.stop();
            }
            catch (Throwable t) {
                t.getMessage();
            }
            this._server = null;
        }
    }

    public void startTaskClient() throws Exception {
        if (this._client == null) {
            this._client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector(BPMMixIn.class.getSimpleName(), (BaseMinaHandler)new MinaTaskClientHandler((SystemEventListener)new DoNothingSystemEventListener())));
        }
        if (!this._clientConnected) {
            this._client.connect(this._host, this._port);
            this._clientConnected = true;
        }
    }

    public void stopTaskClient() {
        if (this._client != null) {
            if (this._clientConnected) {
                try {
                    this._client.disconnect();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
                this._clientConnected = false;
            }
            this._client = null;
        }
    }

    public boolean completeTasksForUsers(String ... userIds) throws Exception {
        boolean keepWorking = false;
        this.startTaskClient();
        for (String userId : userIds) {
            BlockingTaskSummaryResponseHandler btsrh = new BlockingTaskSummaryResponseHandler();
            this._client.getTasksOwned(userId, Locale.getDefault().toString().replaceAll("_", "-"), (TaskClientHandler.TaskSummaryResponseHandler)btsrh);
            List tasks = btsrh.getResults();
            for (TaskSummary task : tasks) {
                if (Status.Completed.equals((Object)task.getStatus())) continue;
                User user = task.getActualOwner();
                BlockingTaskOperationResponseHandler btorh = new BlockingTaskOperationResponseHandler();
                this._client.start(task.getId(), user.getId(), (TaskClientHandler.TaskOperationResponseHandler)btorh);
                btorh.waitTillDone(10000L);
                btorh = new BlockingTaskOperationResponseHandler();
                this._client.complete(task.getId(), user.getId(), null, (TaskClientHandler.TaskOperationResponseHandler)btorh);
                btorh.waitTillDone(10000L);
                keepWorking = true;
            }
        }
        this.stopTaskClient();
        Thread.sleep(1000L);
        return keepWorking;
    }
}

