/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins.jca;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.MessageListener;
import javax.resource.spi.ResourceAdapter;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.ShrinkwrapUtil;
import org.switchyard.test.mixins.AbstractTestMixIn;
import org.switchyard.test.mixins.jca.JCAMixInConfig;
import org.switchyard.test.mixins.jca.MockActivationSpec;
import org.switchyard.test.mixins.jca.MockConnection;
import org.switchyard.test.mixins.jca.MockConnectionFactory;
import org.switchyard.test.mixins.jca.MockConnectionInterface;
import org.switchyard.test.mixins.jca.MockConnectionManager;
import org.switchyard.test.mixins.jca.MockManagedConnection;
import org.switchyard.test.mixins.jca.MockManagedConnectionFactory;
import org.switchyard.test.mixins.jca.MockMappedRecord;
import org.switchyard.test.mixins.jca.MockResourceAdapter;
import org.switchyard.test.mixins.jca.SwitchYardIronJacamarHandler;

public class JCAMixIn
extends AbstractTestMixIn {
    private static final String MOCK_RESOURCE_ADAPTER_XML = "jcamixin-mock-ra.xml";
    private static final String HORNETQ_RESOURCE_ADAPTER_XML = "jcamixin-hornetq-ra.xml";
    private static final String ENV_HORNETQ_VERSION = "HORNETQ_VERSION";
    private static final String ENV_NETTY_VERSION = "NETTY_VERSION";
    private Logger _logger = Logger.getLogger(JCAMixIn.class);
    private SwitchYardIronJacamarHandler _ironJacamar;
    private ResourceAdapterRepository _resourceAdapterRepository;
    private String _mockResourceAdapterName;
    private String _hornetqResourceAdapterName;

    @Override
    public void initialize() {
        try {
            this._ironJacamar = new SwitchYardIronJacamarHandler();
            this._ironJacamar.startup();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Failed to start IronJacamar Embedded: " + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void before(AbstractDeployment deployment) {
        JCAMixInConfig config = this.getTestKit().getTestInstance().getClass().getAnnotation(JCAMixInConfig.class);
        if (!config.mockResourceAdapter().equals("")) {
            this._mockResourceAdapterName = config.mockResourceAdapter();
            this.deployMockResourceAdapter(this._mockResourceAdapterName);
        }
        if (!config.hornetQResourceAdapter().equals("")) {
            this._hornetqResourceAdapterName = config.hornetQResourceAdapter();
            this.deployHornetQResourceAdapter(this._hornetqResourceAdapterName);
        }
        for (String raName : config.resourceAdapters()) {
            this.deployResourceAdapter(raName);
        }
        try {
            this._resourceAdapterRepository = this._ironJacamar.getResourceAdapterRepository();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Could not acquire ResourceAdapterRepository");
        }
        for (Activator activator : this.getTestKit().getActivators()) {
            for (Field f : activator.getClass().getDeclaredFields()) {
                if (f.getType() != ResourceAdapterRepository.class) continue;
                f.setAccessible(true);
                try {
                    f.set(activator, this._resourceAdapterRepository);
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Failed to inject ResourceAdapterRepository into " + activator.getClass()), (Throwable)e);
                }
                finally {
                    f.setAccessible(false);
                }
            }
        }
    }

    public MockResourceAdapter getMockResourceAdapter() {
        return (MockResourceAdapter)MockResourceAdapter.class.cast(this.getResourceAdapter(this._mockResourceAdapterName));
    }

    public ResourceAdapter getResourceAdapter(String name) {
        try {
            String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(name));
            return this._resourceAdapterRepository.getResourceAdapter(raid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deployResourceAdapter(String path) {
        URI uri = null;
        try {
            uri = Thread.currentThread().getContextClassLoader().getResource(path).toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File ra = new File(uri);
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.createFromZipFile(ResourceAdapterArchive.class, (File)ra);
        this.deployResourceAdapterArchive(raa);
    }

    public MappedRecord createCCIMappedRecord() {
        return new MockMappedRecord();
    }

    @Override
    public void uninitialize() {
        try {
            this._ironJacamar.shutdown();
            this._ironJacamar = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void deployMockResourceAdapter(String raName) {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)(this.stripDotRarSuffix(raName) + ".rar"));
        JavaArchive ja = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(UUID.randomUUID().toString() + ".jar"));
        ja.addClasses(new Class[]{MessageListener.class, MockActivationSpec.class, MockConnection.class, MockConnectionFactory.class, MockConnectionManager.class, MockConnectionInterface.class, MockManagedConnection.class, MockManagedConnectionFactory.class, MockResourceAdapter.class});
        raa.addAsLibrary((Archive)ja);
        URL url = Thread.currentThread().getContextClassLoader().getResource(MOCK_RESOURCE_ADAPTER_XML);
        raa.setResourceAdapterXML(url);
        this.deployResourceAdapterArchive(raa);
    }

    private void deployHornetQResourceAdapter(String raName) {
        String hqVersion = System.getenv(ENV_HORNETQ_VERSION);
        String nettyVersion = System.getenv(ENV_NETTY_VERSION);
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)(this.stripDotRarSuffix(raName) + ".rar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.jboss.netty", "netty", nettyVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-ra", hqVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-core-client", hqVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-jms-client", hqVersion, JavaArchive.class, "jar"));
        URL url = Thread.currentThread().getContextClassLoader().getResource(HORNETQ_RESOURCE_ADAPTER_XML);
        raa.setResourceAdapterXML(url);
        this.deployResourceAdapterArchive(raa);
    }

    private void deployResourceAdapterArchive(ResourceAdapterArchive raa) {
        try {
            this._ironJacamar.deploy(raa);
            String raname = this.stripDotRarSuffix(raa.getName());
            String raid = this._ironJacamar.getResourceAdapterIdentifier(raname);
            ConnectorServices.registerResourceAdapter((String)raname);
            ConnectorServices.registerResourceAdapterIdentifier((String)raname, (String)raid);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

