/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.test.mixins.NamingMixIn;

public class TransactionMixIn
extends NamingMixIn {
    private String _storeDir = "target/tx-store";
    private JTAEnvironmentBean _jtaEnvironmentBean;

    @Override
    public void initialize() {
        super.initialize();
        System.setProperty("ObjectStoreEnvironmentBean.objectStoreDir", this._storeDir);
        System.setProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir", this._storeDir);
        try {
            InitialContext initialContext = new InitialContext();
            this._jtaEnvironmentBean = new JTAEnvironmentBean();
            initialContext.bind("java:jboss/TransactionManager", (Object)this._jtaEnvironmentBean.getTransactionManager());
            initialContext.bind("java:jboss/UserTransaction", (Object)this._jtaEnvironmentBean.getUserTransaction());
            initialContext.bind("java:jboss/TransactionSynchronizationRegistry", (Object)this._jtaEnvironmentBean.getTransactionSynchronizationRegistry());
        }
        catch (NamingException e) {
            throw new SwitchYardException("Unable to bind transaction manager in JNDI", (Throwable)e);
        }
    }

    public UserTransaction getUserTransaction() {
        return this._jtaEnvironmentBean.getUserTransaction();
    }

    public TransactionManager getTransactionManager() {
        return this._jtaEnvironmentBean.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this._jtaEnvironmentBean.getTransactionSynchronizationRegistry();
    }
}

