/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins.jca;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.fungal.AbstractFungalDeployment;
import org.jboss.jca.deployers.fungal.RAActivator;
import org.jboss.jca.embedded.Embedded;
import org.jboss.jca.embedded.EmbeddedFactory;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SwitchYardIronJacamarHandler {
    private static final String TEMPLATE_RA_XML = "jcamixin-ironjacamar-template-ra.xml";
    private static final String TEMP_OUT_DIR = System.getProperty("java.io.tmpdir") + File.separator + "switchyard.iron.jacamar";
    private static final String KERNEL_BEAN_NAME = "Kernel";
    private static final String RESOURCE_ADAPTER_REPOSITORY_BEAN_NAME = "ResourceAdapterRepository";
    private static final String RA_ACTIVATOR_BEAN_NAME = "RAActivator";
    private Embedded _embedded;
    private Kernel _kernel;
    private ResourceAdapterRepository _resourceAdapterRepository;
    private List<URL> _manualDeployments = new ArrayList<URL>();

    public void startup() throws Throwable {
        this._embedded = EmbeddedFactory.create();
        try {
            this._embedded.startup();
        }
        catch (Throwable t) {
            System.gc();
            this._embedded.startup();
        }
        this._kernel = (Kernel)this._embedded.lookup(KERNEL_BEAN_NAME, Kernel.class);
    }

    public void deploy(ResourceAdapterArchive raa, Map<String, String> connDefs) throws Throwable {
        File outdir = new File(TEMP_OUT_DIR);
        if (!outdir.exists() && !outdir.mkdir()) {
            throw new RuntimeException("Failed to create directory: " + TEMP_OUT_DIR);
        }
        if (connDefs != null && connDefs.size() != 0) {
            URL raxmlUrl = this.createRaXml(raa.getName(), connDefs);
            RAActivator activator = (RAActivator)this._embedded.lookup(RA_ACTIVATOR_BEAN_NAME, RAActivator.class);
            activator.setEnabled(false);
            this._embedded.deploy(raa);
            this._embedded.deploy(raxmlUrl);
            this._manualDeployments.add(raxmlUrl);
            activator.setEnabled(true);
        } else {
            this._embedded.deploy(raa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Throwable {
        try {
            for (URL d : this._manualDeployments) {
                try {
                    this._embedded.undeploy(d);
                    new File(d.toURI()).delete();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
            this._embedded.shutdown();
        }
        finally {
            new FileUtil().delete(new File(TEMP_OUT_DIR));
            this._kernel = null;
            this._embedded = null;
        }
    }

    public Embedded getEmbeddedInstance() {
        return this._embedded;
    }

    public ResourceAdapterRepository getResourceAdapterRepository() throws Throwable {
        if (this._resourceAdapterRepository != null) {
            return this._resourceAdapterRepository;
        }
        this._resourceAdapterRepository = (ResourceAdapterRepository)this._embedded.lookup(RESOURCE_ADAPTER_REPOSITORY_BEAN_NAME, ResourceAdapterRepository.class);
        return this._resourceAdapterRepository;
    }

    public String getResourceAdapterIdentifier(String raName) throws Exception {
        List deployments = this.getFieldValue(this._kernel, List.class, "deployments");
        for (Object deploy : deployments) {
            if (!(deploy instanceof AbstractFungalDeployment) || !this.getFieldValue(deploy, Boolean.TYPE, "activator").booleanValue() || !this.getFieldValue(deploy, String.class, "deploymentName").equals(raName)) continue;
            return this.getFieldValue(deploy, String.class, "raKey");
        }
        return null;
    }

    private URL createRaXml(String raName, Map<String, String> connDefs) throws Exception {
        String cfJndi = connDefs.keySet().toArray(new String[0])[0];
        String cfClass = connDefs.get(cfJndi);
        InputStream template = Thread.currentThread().getContextClassLoader().getResourceAsStream(TEMPLATE_RA_XML);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(template);
        Node archive = doc.getElementsByTagName("archive").item(0);
        archive.setTextContent(raName);
        Node connection = doc.getElementsByTagName("connection-definition").item(0);
        NamedNodeMap attributes = connection.getAttributes();
        attributes.getNamedItem("class-name").setNodeValue(cfClass);
        attributes.getNamedItem("jndi-name").setNodeValue(cfJndi);
        String raxml = this.stripDotRarSuffix(raName);
        if (!raxml.endsWith("-ra")) {
            raxml = raxml + "-ra";
        }
        raxml = raxml + ".xml";
        File outFile = new File(TEMP_OUT_DIR, raxml);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        DOMSource src = new DOMSource(doc);
        StreamResult res = new StreamResult(outFile);
        t.transform(src, res);
        return outFile.toURI().toURL();
    }

    private <T> T getFieldValue(Object target, Class<T> type, String name) throws Exception {
        for (Class<?> targetClass = target.getClass(); targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            try {
                Field f = targetClass.getDeclaredField(name);
                if (type != Object.class && !f.getType().isAssignableFrom(type)) continue;
                f.setAccessible(true);
                Object val = f.get(target);
                f.setAccessible(false);
                return (T)val;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return null;
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

