/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.TestCase;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;

public class MockHandler
extends BaseHandler {
    private final LinkedBlockingQueue<Exchange> _messages = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Exchange> _faults = new LinkedBlockingQueue();
    private static final int DEFAULT_SLEEP_MS = 100;
    private static final int DEFAULT_WAIT_TIMEOUT = 5000;
    private long _waitTimeout = 5000L;
    private Object _replyContent;
    private Behavior _behavior;

    public long getWaitTimeout() {
        return this._waitTimeout;
    }

    public void setWaitTimeout(long waitTimeout) {
        this._waitTimeout = waitTimeout;
    }

    public LinkedBlockingQueue<Exchange> getMessages() {
        return this._messages;
    }

    public LinkedBlockingQueue<Exchange> getFaults() {
        return this._faults;
    }

    public MockHandler forwardInToOut() {
        this._behavior = Behavior.FORWARD_IN_TO_OUT;
        return this;
    }

    public MockHandler forwardInToFault() {
        this._behavior = Behavior.FORWARD_IN_TO_FAULT;
        return this;
    }

    public MockHandler replyWithOut(Object content) {
        this._behavior = Behavior.REPLY_WITH_OUT;
        this._replyContent = content;
        return this;
    }

    public MockHandler replyWithFault(Object content) {
        this._behavior = Behavior.REPLY_WITH_FAULT;
        this._replyContent = content;
        return this;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this._messages.offer(exchange);
        if (this._behavior == null || exchange.getContract().getProviderOperation().getExchangePattern().equals((Object)ExchangePattern.IN_ONLY)) {
            return;
        }
        switch (this._behavior) {
            case FORWARD_IN_TO_OUT: {
                exchange.send(exchange.getMessage());
                break;
            }
            case FORWARD_IN_TO_FAULT: {
                exchange.sendFault(exchange.getMessage());
                break;
            }
            case REPLY_WITH_OUT: {
                exchange.send(exchange.createMessage().setContent(this._replyContent));
                break;
            }
            case REPLY_WITH_FAULT: {
                exchange.sendFault(exchange.createMessage().setContent(this._replyContent));
            }
        }
    }

    public void handleFault(Exchange exchange) {
        this._faults.offer(exchange);
    }

    public MockHandler waitForOKMessage() {
        this.waitFor(this._messages, 1);
        return this;
    }

    public MockHandler waitForFaultMessage() {
        this.waitFor(this._faults, 1);
        return this;
    }

    private void waitFor(LinkedBlockingQueue<Exchange> eventQueue, int numMessages) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + this._waitTimeout) {
            if (eventQueue.size() >= numMessages) {
                return;
            }
            this.sleep();
        }
        TestCase.fail((String)("Timed out waiting on event queue length to be " + numMessages + " or greater."));
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            TestCase.fail((String)("Failed to sleep: " + e.getMessage()));
        }
    }

    private static enum Behavior {
        FORWARD_IN_TO_OUT,
        FORWARD_IN_TO_FAULT,
        REPLY_WITH_OUT,
        REPLY_WITH_FAULT;

    }
}

