/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.model.MergeScanner;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.Models;
import org.switchyard.config.model.Scannable;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.ActivatorLoader;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Deployment;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.test.BeforeDeploy;
import org.switchyard.test.Invoker;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.MockHandler;
import org.switchyard.test.SimpleTestDeployment;
import org.switchyard.test.SwitchYardTestCaseConfig;
import org.switchyard.test.TestMixIn;
import org.switchyard.test.mixins.AbstractTestMixIn;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.w3c.dom.Document;

public class SwitchYardTestKit {
    private static Logger _logger = Logger.getLogger(SwitchYardTestKit.class);
    protected static final String NULL_CONFIG = "$$NULL_SW_CONFIG$$";
    private Object _testInstance;
    private SwitchYardModel _configModel;
    private AbstractDeployment _deployment;
    private Map<Class<? extends TestMixIn>, MixInEntry> _testMixInInstances = new LinkedHashMap<Class<? extends TestMixIn>, MixInEntry>();
    private List<Activator> _activators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchYardTestKit(Object testInstance) throws Exception {
        this._testInstance = testInstance;
        SwitchYardTestCaseConfig testCaseConfig = testInstance.getClass().getAnnotation(SwitchYardTestCaseConfig.class);
        if (testCaseConfig != null) {
            Class<? extends TestMixIn>[] testMixIns;
            String config = testCaseConfig.config();
            if (config != null && !config.equals(NULL_CONFIG)) {
                File file;
                InputStream is = this.getResourceAsStream(config);
                if (is == null && (file = new File(config)).isFile()) {
                    is = new FileInputStream(file);
                }
                if (is == null) {
                    Assert.fail((String)("Failed to locate test configuration '" + config + "' on the classpath or project sub-directory. See the @" + SwitchYardTestCaseConfig.class.getSimpleName() + " annotation on test class '" + this._testInstance.getClass().getName() + "'."));
                }
                try {
                    this._configModel = this.createSwitchYardModel(is, this.createScanners(testCaseConfig), testCaseConfig.validate());
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        t.getMessage();
                    }
                }
            }
            if ((testMixIns = testCaseConfig.mixins()) == null) {
                _logger.debug((Object)"No TestMixIns for test.");
            } else if (testMixIns.length == 1 && testMixIns[0] == NullMixIns.class) {
                _logger.debug((Object)"No TestMixIns for test.");
            } else {
                for (Class<? extends TestMixIn> mixIn : testMixIns) {
                    this._testMixInInstances.put(mixIn, null);
                }
            }
        }
        this.createMixInInstances();
        this.initializeMixIns();
    }

    public void start() throws Exception {
        this.beforeDeploy();
        this.deploy();
    }

    public void cleanup() {
        this.undeploy();
        this.cleanupMixIns();
    }

    public Object getTestInstance() {
        return this._testInstance;
    }

    public SwitchYardModel getConfigModel() {
        return this._configModel;
    }

    public List<Activator> getActivators() {
        return this._activators;
    }

    public AbstractDeployment getDeployment() {
        return this._deployment;
    }

    public ServiceDomain getServiceDomain() {
        this.assertDeployed();
        return this._deployment.getDomain();
    }

    public QName createQName(String localPart) {
        CompositeModel composite;
        String tns = this._configModel != null ? ((composite = this._configModel.getComposite()) != null ? composite.getTargetNamespace() : this._configModel.getTargetNamespace()) : null;
        return XMLHelper.createQName(tns, (String)localPart);
    }

    public MockHandler registerInOutService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(this.createQName(serviceName), (ServiceInterface)new InOutService(), (ExchangeHandler)handler);
        return handler;
    }

    public void registerInOutService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(this.createQName(serviceName), (ServiceInterface)new InOutService(), serviceHandler);
    }

    public void registerInOutService(String serviceName, ExchangeHandler serviceHandler, ServiceInterface metadata) {
        this.getServiceDomain().registerService(this.createQName(serviceName), metadata, serviceHandler);
    }

    public MockHandler registerInOnlyService(String serviceName) {
        MockHandler handler = new MockHandler();
        this.getServiceDomain().registerService(this.createQName(serviceName), (ServiceInterface)new InOnlyService(), (ExchangeHandler)handler);
        return handler;
    }

    public void registerInOnlyService(String serviceName, ExchangeHandler serviceHandler) {
        this.getServiceDomain().registerService(this.createQName(serviceName), (ServiceInterface)new InOnlyService(), serviceHandler);
    }

    public MockHandler replaceService(String name) throws SwitchYardException {
        return this.replaceService(this.createQName(name));
    }

    public void replaceService(String name, ExchangeHandler handler) throws SwitchYardException {
        this.replaceService(this.createQName(name), handler);
    }

    public MockHandler replaceService(QName name) throws SwitchYardException {
        MockHandler handler = new MockHandler();
        this.replaceService(name, (ExchangeHandler)handler);
        return handler;
    }

    public void replaceService(QName name, ExchangeHandler handler) throws SwitchYardException {
        List services = this.getServiceDomain().getServices(name);
        if (services.isEmpty()) {
            throw new SwitchYardException("Failed to replace service: " + name + ".  No service is registered with that name.");
        }
        Service replacedService = (Service)services.get(0);
        replacedService.unregister();
        this.getServiceDomain().registerService(name, replacedService.getInterface(), handler, replacedService.getServiceMetadata());
    }

    public void removeService(String serviceName) {
        this.removeService(this.createQName(serviceName));
    }

    public void removeService(QName serviceName) {
        for (Service service : this.getServiceDomain().getServices(serviceName)) {
            service.unregister();
        }
    }

    public void addTransformer(Transformer transformer) {
        this.getServiceDomain().getTransformerRegistry().addTransformer(transformer);
    }

    public Invoker newInvoker(QName serviceName) {
        return new Invoker(this.getServiceDomain(), serviceName);
    }

    public Invoker newInvoker(String serviceName) {
        return this.newInvoker(this.createQName(serviceName));
    }

    public Transformer newTransformer(TransformModel transformModel) {
        return this._deployment.getTransformerRegistryLoader().newTransformer(transformModel);
    }

    public Transformer registerTransformer(TransformModel transformModel) {
        Object transformer;
        if (transformModel.getFrom() == null || transformModel.getTo() == null) {
            Assert.fail((String)"Invalid TransformModel instance.  Must specify 'from' and 'to' data types.");
        }
        if ((transformer = this._deployment.getTransformerRegistryLoader().newTransformer(transformModel)).getFrom() == null) {
            transformer = new TransformerWrapper((Transformer)transformer, transformModel);
        }
        this._deployment.getDomain().getTransformerRegistry().addTransformer(transformer);
        return transformer;
    }

    public List<TestMixIn> getMixIns() {
        ArrayList<TestMixIn> mixins = new ArrayList<TestMixIn>();
        for (MixInEntry entry : this._testMixInInstances.values()) {
            mixins.add(entry.getMixIn());
        }
        return Collections.unmodifiableList(mixins);
    }

    public <T extends TestMixIn> T getMixIn(Class<T> type) {
        MixInEntry mixIn;
        if (this._testMixInInstances == null || this._testMixInInstances.isEmpty()) {
            Assert.fail((String)"No TestMixIns specified on Test class instance.  Use the @TestMixIns annotation.");
        }
        if (this._testMixInInstances.size() != this.getMixIns().size()) {
            Assert.fail((String)"TestMixIn instances only available during test method execution.");
        }
        if ((mixIn = this._testMixInInstances.get(type)) == null) {
            Assert.fail((String)("Required TestMixIn '" + type.getName() + "' is not specified on TestCase '" + this._testInstance.getClass().getName() + "'."));
        }
        return (T)((TestMixIn)type.cast(mixIn.getMixIn()));
    }

    public Set<TestMixIn> getRequiredDependencies(TestMixIn mixIn) {
        return Collections.unmodifiableSet(this._testMixInInstances.get(mixIn.getClass()).getRequiredDeps());
    }

    public Set<TestMixIn> getOptionalDependencies(TestMixIn mixIn) {
        return Collections.unmodifiableSet(this._testMixInInstances.get(mixIn.getClass()).getOptionalDeps());
    }

    public InputStream getResourceAsStream(String name) {
        try {
            return Classes.getResourceAsStream((String)name, this._testInstance.getClass());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readResourceBytes(String path) {
        InputStream resourceStream;
        if (path == null) {
            Assert.fail((String)"Resource 'path' not specified.");
        }
        if ((resourceStream = this.getResourceAsStream(path)) == null) {
            Assert.fail((String)("Resource '" + path + "' not found on classpath relative to test class '" + this._testInstance.getClass().getName() + "'.  May need to fix the relative path, or make the path absolute."));
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            byte[] readBuffer = new byte[128];
            int readCount = 0;
            while ((readCount = resourceStream.read(readBuffer)) != -1) {
                byteOutStream.write(readBuffer, 0, readCount);
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected read error reading classpath resource '" + path + "'" + e.getMessage()));
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception closing classpath resource '" + path + "'" + e.getMessage()));
            }
        }
        return byteOutStream.toByteArray();
    }

    public String readResourceString(String path) {
        try {
            return new String(this.readResourceBytes(path), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)("Unexpected exception reading classpath resource '" + path + "' as a String.  Perhaps this resource is a binary resource that cannot be encoded as a String." + e.getMessage()));
            return null;
        }
    }

    public Document readResourceDocument(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(this.getResourceAsStream(path));
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception reading classpath resource '" + path + "' as a DOM Document." + e.getMessage()));
            return null;
        }
    }

    public SwitchYardModel loadSwitchYardModel(InputStream configModel) {
        return this.loadSwitchYardModel(configModel, true);
    }

    public SwitchYardModel loadSwitchYardModel(InputStream configModel, boolean validate) {
        return this.loadConfigModel(configModel, SwitchYardModel.class, validate);
    }

    public <M extends Model> M loadConfigModel(InputStream configModel, Class<M> modelType) {
        return this.loadConfigModel(configModel, modelType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Model> M loadConfigModel(InputStream configModel, Class<M> modelType, boolean validate) {
        if (configModel == null) {
            throw new IllegalArgumentException("null 'configModel' arg.");
        }
        try {
            Model pulledModel = new ModelPuller().pull(configModel);
            if (validate) {
                pulledModel.assertModelValid();
            }
            Model model = pulledModel;
            return (M)model;
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected error building " + modelType.getSimpleName() + ": " + e.getMessage()));
        }
        finally {
            try {
                configModel.close();
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected error closing " + modelType.getSimpleName() + " stream: " + e.getMessage()));
            }
        }
        return null;
    }

    public void compareXMLToResource(String xml, String resourcePath) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLAssert.assertXMLEqual((String)this.readResourceString(resourcePath), (String)xml);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected error performing XML comparison: " + e.getMessage()));
        }
    }

    public static void compareXMLToString(String xml, String string) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLAssert.assertXMLEqual((String)string, (String)xml);
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected error performing XML comparison.");
        }
    }

    public void traceMessages(boolean doTrace) {
        this.getServiceDomain().setProperty("org.switchyard.handlers.messageTrace.enabled", (Object)true);
    }

    private void beforeDeploy() throws Exception {
        Method[] publicMethods;
        for (Method method : publicMethods = this._testInstance.getClass().getMethods()) {
            BeforeDeploy beforeAnno = method.getAnnotation(BeforeDeploy.class);
            if (beforeAnno == null) continue;
            method.invoke(this._testInstance, new Object[0]);
        }
    }

    private final void deploy() throws Exception {
        this._deployment = this.createDeployment();
        ServiceDomain domain = new ServiceDomainManager().createDomain(ServiceDomainManager.ROOT_DOMAIN, this._deployment.getConfig());
        this._activators = ActivatorLoader.createActivators((ServiceDomain)domain);
        SwitchYardTestCaseConfig testCaseConfig = this._testInstance.getClass().getAnnotation(SwitchYardTestCaseConfig.class);
        if (testCaseConfig != null) {
            HashSet<String> excludes;
            HashSet<String> includes = new HashSet<String>(Arrays.asList(testCaseConfig.include()));
            if (!includes.isEmpty()) {
                Iterator<Activator> activatorsIt = this._activators.iterator();
                while (activatorsIt.hasNext()) {
                    Activator activator = activatorsIt.next();
                    if (this.intersection(includes, activator.getActivationTypes())) continue;
                    activatorsIt.remove();
                }
            }
            if (!(excludes = new HashSet<String>(Arrays.asList(testCaseConfig.exclude()))).isEmpty()) {
                Iterator<Activator> activatorsIt = this._activators.iterator();
                while (activatorsIt.hasNext()) {
                    Activator activator = activatorsIt.next();
                    if (!this.intersection(excludes, activator.getActivationTypes())) continue;
                    activatorsIt.remove();
                }
            }
        }
        this._deployment.init(domain, this._activators);
        this.mixInBefore();
        this._deployment.setFailOnMissingActivator(false);
        this._deployment.start();
    }

    private final void undeploy() {
        this.assertDeployed();
        this._deployment.stop();
        this.mixInAfter();
        this._deployment.destroy();
    }

    private AbstractDeployment createDeployment() throws Exception {
        if (this._configModel != null) {
            return new Deployment(this._configModel);
        }
        return new SimpleTestDeployment();
    }

    private void initializeMixIns() {
        for (TestMixIn mixIn : this.getMixIns()) {
            mixIn.initialize();
        }
    }

    private void mixInBefore() {
        for (TestMixIn mixIn : this.getMixIns()) {
            mixIn.before(this._deployment);
        }
    }

    private void mixInAfter() {
        ArrayList<TestMixIn> mixins = new ArrayList<TestMixIn>(this.getMixIns());
        Collections.reverse(mixins);
        for (TestMixIn mixIn : mixins) {
            mixIn.after(this._deployment);
        }
    }

    private void cleanupMixIns() {
        ArrayList<TestMixIn> mixins = new ArrayList<TestMixIn>(this.getMixIns());
        Collections.reverse(mixins);
        for (TestMixIn mixIn : mixins) {
            mixIn.uninitialize();
        }
    }

    private void createMixInInstances() {
        if (this._testMixInInstances == null || this._testMixInInstances.isEmpty()) {
            return;
        }
        LinkedHashSet<Class<? extends TestMixIn>> mixinClasses = new LinkedHashSet<Class<? extends TestMixIn>>(this._testMixInInstances.keySet());
        for (Class clazz : mixinClasses) {
            this.createMixInRecursively(clazz);
        }
    }

    private MixInEntry createMixInRecursively(Class<? extends TestMixIn> mixInType) {
        if (this._testMixInInstances.containsKey(mixInType) && this._testMixInInstances.get(mixInType) != null) {
            return this._testMixInInstances.get(mixInType);
        }
        LinkedHashSet<TestMixIn> requiredDeps = new LinkedHashSet<TestMixIn>();
        LinkedHashSet<TestMixIn> optionalDeps = new LinkedHashSet<TestMixIn>();
        MixInDependencies dependencies = mixInType.getAnnotation(MixInDependencies.class);
        if (dependencies != null) {
            Class<? extends TestMixIn>[] passiveDependencies;
            Class<? extends TestMixIn>[] activeDependencies = dependencies.required();
            if (activeDependencies != null && activeDependencies[0] != NullMixIns.class) {
                for (Class<? extends TestMixIn> mixin : activeDependencies) {
                    MixInEntry dependency = this.createMixInRecursively(mixin);
                    requiredDeps.add(dependency.getMixIn());
                    this._testMixInInstances.put(mixin, dependency);
                }
            }
            if ((passiveDependencies = dependencies.optional()) != null && passiveDependencies[0] != NullMixIns.class) {
                for (Class<? extends TestMixIn> mixin : passiveDependencies) {
                    if (!this._testMixInInstances.containsKey(mixin)) continue;
                    MixInEntry dependency = this.createMixInRecursively(mixin);
                    optionalDeps.add(dependency.getMixIn());
                    this._testMixInInstances.put(mixin, dependency);
                }
            }
        }
        TestMixIn testMixIn = SwitchYardTestKit.newMixInInstance(mixInType, this._testInstance);
        testMixIn.setTestKit(this);
        MixInEntry entry = new MixInEntry(testMixIn, requiredDeps, optionalDeps);
        this._testMixInInstances.remove(mixInType);
        this._testMixInInstances.put(mixInType, entry);
        return entry;
    }

    protected static <T extends TestMixIn> T newMixInInstance(Class<T> mixInType, Object testInstance) {
        Method[] methods;
        Class<?> testClass = testInstance.getClass();
        for (Method method : methods = testClass.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || method.getReturnType() != mixInType || method.getParameterTypes().length != 0) continue;
            try {
                if (Modifier.isStatic(modifiers)) {
                    return (T)((TestMixIn)mixInType.cast(method.invoke(null, new Object[0])));
                }
                return (T)((TestMixIn)mixInType.cast(method.invoke(testInstance, new Object[0])));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to create instance of TestMixIn type " + mixInType.getName() + ".  Error invoking the MixIn factory method '" + method.getName() + "': " + e.getMessage()));
                return null;
            }
        }
        try {
            return (T)((TestMixIn)mixInType.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to create instance of TestMixIn type " + mixInType.getName() + " via public default constructor: " + e.getMessage()));
            return null;
        }
    }

    private SwitchYardModel createSwitchYardModel(InputStream configModel, List<Scanner<V1SwitchYardModel>> scanners, boolean validate) {
        Assert.assertNotNull((String)"Test 'configModel' is null.", (Object)configModel);
        try {
            SwitchYardModel returnModel;
            SwitchYardModel model = this.loadSwitchYardModel(configModel, false);
            ClassLoader classLoader = this._testInstance.getClass().getClassLoader();
            if (scanners != null && !scanners.isEmpty() && classLoader instanceof URLClassLoader) {
                String switchyardNamespace = model.getModelRootNamespace();
                MergeScanner merge_scanner = new MergeScanner(true, scanners);
                List<URL> scanURLs = this.getScanURLs((URLClassLoader)classLoader);
                ScannerInput scanner_input = new ScannerInput().setSwitchyardNamespace(switchyardNamespace).setCompositeName(model.getName()).setURLs(scanURLs);
                V1SwitchYardModel scannedModel = (V1SwitchYardModel)merge_scanner.scan(scanner_input).getModel();
                returnModel = (SwitchYardModel)Models.merge((Model)scannedModel, (Model)model, (boolean)false);
            } else {
                returnModel = model;
            }
            if (validate) {
                returnModel.assertModelValid();
            }
            return returnModel;
        }
        catch (IOException ioEx) {
            throw new SwitchYardException("Failed to read switchyard config.", (Throwable)ioEx);
        }
    }

    private void assertDeployed() {
        if (this._deployment == null) {
            Assert.fail((String)"TestCase deployment not yet deployed.  You may need to make an explicit call to the deploy() method.");
        }
    }

    private List<Scanner<V1SwitchYardModel>> createScanners(SwitchYardTestCaseConfig testCaseConfig) {
        ArrayList<Scanner<V1SwitchYardModel>> scanners = new ArrayList<Scanner<V1SwitchYardModel>>();
        if (testCaseConfig != null) {
            Class<? extends Scanner>[] scannerClasses = testCaseConfig.scanners();
            if (scannerClasses == null) {
                _logger.debug((Object)"No Scanners for test.");
            } else if (scannerClasses.length == 1 && scannerClasses[0] == NullScanners.class) {
                _logger.debug((Object)"No Scanners for test.");
            } else {
                for (Class<? extends Scanner> scannerClass : scannerClasses) {
                    try {
                        scanners.add((Scanner<V1SwitchYardModel>)scannerClass.newInstance());
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Exception creating instance of Scanner class '" + scannerClass.getName() + "': " + e.getMessage()));
                    }
                }
            }
        }
        return scanners;
    }

    private List<URL> getScanURLs(URLClassLoader classLoader) {
        URL[] classPathURLs = classLoader.getURLs();
        ArrayList<URL> scanURLs = new ArrayList<URL>();
        for (URL classpathURL : classPathURLs) {
            try {
                File file = ClasspathScanner.toClassPathFile((URL)classpathURL);
                if (!file.isDirectory()) continue;
                scanURLs.add(classpathURL);
            }
            catch (IOException e) {
                Assert.fail((String)("Failed to convert classpath URL '" + classpathURL + "' to a File instance."));
            }
        }
        if (scanURLs.isEmpty()) {
            try {
                scanURLs.add(new File("target/test-classes").toURI().toURL());
                scanURLs.add(new File("target/classes").toURI().toURL());
            }
            catch (MalformedURLException e) {
                Assert.fail((String)("Unexpected exception adding target test classes folders to test scan URLs: " + e.getMessage()));
            }
        }
        return scanURLs;
    }

    private boolean intersection(Collection<String> set1, Collection<String> set2) {
        if (set1.isEmpty() || set2.isEmpty()) {
            return false;
        }
        HashSet<String> set1Copy = new HashSet<String>(set1);
        set1Copy.removeAll(set2);
        return set1Copy.size() < set1.size();
    }

    protected static class MixInEntry {
        private final TestMixIn _mixin;
        private Set<TestMixIn> _requiredDeps;
        private Set<TestMixIn> _optionalDeps;

        public MixInEntry(TestMixIn mixin, Set<TestMixIn> requiredDeps, Set<TestMixIn> optionalDeps) {
            this._mixin = mixin;
            this._requiredDeps = requiredDeps;
            this._optionalDeps = optionalDeps;
        }

        public TestMixIn getMixIn() {
            return this._mixin;
        }

        public Set<TestMixIn> getRequiredDeps() {
            return this._requiredDeps;
        }

        public Set<TestMixIn> getOptionalDeps() {
            return this._optionalDeps;
        }
    }

    protected static final class NullMixIns
    extends AbstractTestMixIn {
        protected NullMixIns() {
        }
    }

    protected static final class NullScanners
    implements Scanner {
        protected NullScanners() {
        }

        public ScannerOutput scan(ScannerInput scannerInput) throws IOException {
            return null;
        }
    }

    @Scannable(value=false)
    private static final class TransformerWrapper
    extends BaseTransformer {
        private Transformer _transformer;
        private TransformModel _transformModel;

        private TransformerWrapper(Transformer transformer, TransformModel transformModel) {
            this._transformer = transformer;
            this._transformModel = transformModel;
        }

        public Object transform(Object from) {
            return this._transformer.transform(from);
        }

        public QName getFrom() {
            return this._transformModel.getFrom();
        }

        public QName getTo() {
            return this._transformModel.getTo();
        }
    }
}

