/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorFactory;
import org.switchyard.validate.ValidatorFactoryClass;
import org.switchyard.validate.ValidatorTypes;
import org.switchyard.validate.config.model.JavaValidateModel;

public final class ValidatorUtil {
    private static final QName OBJECT_TYPE = JavaService.toMessageType(Object.class);

    private ValidatorUtil() {
    }

    public static Validator<?> newValidator(ValidateModel validateModel) {
        return ValidatorUtil.newValidators(validateModel).iterator().next();
    }

    public static Collection<Validator<?>> newValidators(ValidateModel validateModel) {
        Collection<Object> validators = null;
        if (validateModel instanceof JavaValidateModel) {
            String className = ((JavaValidateModel)validateModel).getClazz();
            try {
                Class validateClass = Classes.forName((String)className, ValidatorUtil.class);
                validators = ValidatorUtil.newValidators(validateClass, validateModel.getName());
            }
            catch (Exception e) {
                throw new SwitchYardException("Error constructing Validator instance for class '" + className + "'.", (Throwable)e);
            }
        } else {
            ValidatorFactory factory = ValidatorUtil.newValidatorFactory(validateModel);
            validators = new ArrayList();
            validators.add(factory.newValidator(validateModel));
        }
        if (validators == null || validators.isEmpty()) {
            throw new SwitchYardException("Unknown ValidateModel type '" + validateModel.getClass().getName() + "'.");
        }
        return validators;
    }

    public static Validator<?> newValidator(Class<?> clazz, QName name) {
        return ValidatorUtil.newValidators(clazz, name).iterator().next();
    }

    public static Collection<Validator<?>> newValidators(Class<?> clazz, QName name) {
        Method[] publicMethods;
        Object validatorObject;
        if (!ValidatorUtil.isValidator(clazz)) {
            throw new SwitchYardException("Invalid Validator class '" + clazz.getName() + "'.  Must implement the Validator interface, or have methods annotated with the @Validator annotation.");
        }
        boolean nameIsWild = ValidatorUtil.isWildcardType(name);
        ArrayList validators = new ArrayList();
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            if (!nameIsWild && !validatorMethod.getName().equals(name)) continue;
            validators.add(ValidatorUtil.newValidator(validatorObject, validatorMethod.getMethod(), validatorMethod.getName()));
        }
        if (validatorObject instanceof Validator) {
            Validator validator = (Validator)validatorObject;
            QName vldName = validator.getName();
            if (vldName.equals(OBJECT_TYPE)) {
                validators.add(validator);
            } else if (nameIsWild || vldName.equals(name)) {
                validators.add(validator);
            } else if (ValidatorUtil.isAssignableFrom(vldName, name)) {
                validators.add(validator);
            }
            if (!nameIsWild) {
                validator.setName(name);
            }
        }
        if (validators.isEmpty()) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + clazz.getName() + "'.  Class does not support a validation for type '" + name + "'.");
        }
        return validators;
    }

    public static List<ValidatorTypes> listValidations(Class<?> clazz) {
        Method[] publicMethods;
        QName name;
        Object validatorObject;
        ArrayList<ValidatorTypes> validations = new ArrayList<ValidatorTypes>();
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        if (validatorObject instanceof Validator && (name = ((Validator)validatorObject).getName()) != null) {
            validations.add(new ValidatorTypes(name));
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            validations.add(new ValidatorTypes(validatorMethod.getName()));
        }
        return validations;
    }

    public static boolean isValidator(Class<?> clazz) {
        Method[] publicMethods;
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnnotation()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Validator.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            if (!publicMethod.isAnnotationPresent(org.switchyard.annotations.Validator.class)) continue;
            return true;
        }
        return false;
    }

    private static Validator newValidator(final Object validatorObject, final Method publicMethod, QName name) {
        BaseValidator validator = new BaseValidator(name){

            public boolean validate(Object subject) {
                try {
                    return Boolean.parseBoolean(publicMethod.invoke(validatorObject, subject).toString());
                }
                catch (InvocationTargetException e) {
                    throw new SwitchYardException("Error executing @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", e.getCause());
                }
                catch (Exception e) {
                    throw new SwitchYardException("Error executing @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", (Throwable)e);
                }
            }

            public Class<?> getType() {
                return publicMethod.getParameterTypes()[0];
            }
        };
        return validator;
    }

    private static boolean isAssignableFrom(QName a, QName b) {
        if (QNameUtil.isJavaMessageType((QName)a) && QNameUtil.isJavaMessageType((QName)b)) {
            Class aType = QNameUtil.toJavaMessageType((QName)a);
            Class bType = QNameUtil.toJavaMessageType((QName)b);
            if (aType == null || bType == null) {
                return false;
            }
            return aType.isAssignableFrom(bType);
        }
        return false;
    }

    private static boolean isWildcardType(QName type) {
        return type.toString().equals("*");
    }

    private static ValidatorMethod toValidatorMethod(Method publicMethod, org.switchyard.annotations.Validator validatorAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw new SwitchYardException("Invalid @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must have exactly 1 parameter.");
        }
        Class<?> type = params[0];
        QName name = !validatorAnno.name().trim().equals("") ? QName.valueOf(validatorAnno.name().trim()) : JavaService.toMessageType(type);
        return new ValidatorMethod(name, publicMethod);
    }

    private static ValidatorFactory newValidatorFactory(ValidateModel validateModel) {
        ValidatorFactoryClass validatorFactoryClass = validateModel.getClass().getAnnotation(ValidatorFactoryClass.class);
        if (validatorFactoryClass == null) {
            throw new SwitchYardException("ValidateModel type '" + validateModel.getClass().getName() + "' is not annotated with an @ValidatorFactoryClass annotation.");
        }
        Class<? extends ValidatorFactory> factoryClass = validatorFactoryClass.value();
        if (!ValidatorFactory.class.isAssignableFrom(factoryClass)) {
            throw new SwitchYardException("Invalid ValidatorFactory implementation.  Must implement '" + ValidatorFactory.class.getName() + "'.");
        }
        try {
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to create an instance of ValidatorFactory '" + factoryClass.getName() + "'.  Class must have a public default constructor and not be abstract.");
        }
    }

    private static class ValidatorMethod
    extends ValidatorTypes {
        private Method _method;

        ValidatorMethod(QName name, Method publicMethod) {
            super(name);
            this._method = publicMethod;
        }

        private Method getMethod() {
            return this._method;
        }
    }
}

