/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.SwitchYardException;
import org.switchyard.common.cdi.CDIUtil;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;
import org.switchyard.validate.config.model.JavaValidateModel;
import org.switchyard.validate.internal.ValidatorFactory;
import org.switchyard.validate.internal.ValidatorFactoryClass;
import org.switchyard.validate.internal.ValidatorTypes;

public final class ValidatorUtil {
    private static final Logger LOGGER = Logger.getLogger(ValidatorUtil.class);
    private static final QName OBJECT_TYPE = JavaTypes.toMessageType(Object.class);

    private ValidatorUtil() {
    }

    public static Validator<?> newValidator(ValidateModel validateModel) {
        return ValidatorUtil.newValidators(validateModel).iterator().next();
    }

    public static Collection<Validator<?>> newValidators(ValidateModel validateModel) {
        Collection<Validator<?>> validators = null;
        if (validateModel instanceof JavaValidateModel) {
            JavaValidateModel javaValidateModel = (JavaValidateModel)JavaValidateModel.class.cast(validateModel);
            String bean = javaValidateModel.getBean();
            if (bean != null) {
                if (CDIUtil.lookupBeanManager() == null) {
                    throw new SwitchYardException("CDI BeanManager couldn't be found. A Java validator class name must be specified if CDI is not enabled.");
                }
                Object validator = CDIUtil.lookupBean((String)bean);
                if (validator == null) {
                    throw new SwitchYardException("The Java validator bean '" + bean + "' couldn't be found in CDI registry.");
                }
                validators = ValidatorUtil.newValidators(validator, validateModel.getName());
            } else {
                String className = ((JavaValidateModel)validateModel).getClazz();
                if (className == null) {
                    throw new SwitchYardException("'bean' or 'class' must be specified for Java validator definition.");
                }
                try {
                    Class validateClass = Classes.forName((String)className, ValidatorUtil.class);
                    validators = ValidatorUtil.newValidators(validateClass, validateModel.getName());
                }
                catch (Exception e) {
                    throw new SwitchYardException("Error constructing Validator instance for class '" + className + "'.", (Throwable)e);
                }
            }
        } else {
            ValidatorFactory factory = ValidatorUtil.newValidatorFactory(validateModel);
            validators = new ArrayList();
            validators.add(factory.newValidator(validateModel));
        }
        if (validators == null || validators.isEmpty()) {
            throw new SwitchYardException("Unknown ValidateModel type '" + validateModel.getClass().getName() + "'.");
        }
        return validators;
    }

    public static Validator<?> newValidator(Class<?> clazz, QName name) {
        return ValidatorUtil.newValidators(clazz, name).iterator().next();
    }

    public static Collection<Validator<?>> newValidators(Class<?> clazz, QName name) {
        Object validatorObject;
        if (!ValidatorUtil.isValidator(clazz)) {
            throw new SwitchYardException("Invalid Validator class '" + clazz.getName() + "'.  Must implement the Validator interface, or have methods annotated with the @Validator annotation.");
        }
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        return ValidatorUtil.newValidators(validatorObject, name);
    }

    public static Collection<Validator<?>> newValidators(Object validatorObject, QName name) {
        Method[] publicMethods;
        boolean nameIsWild = ValidatorUtil.isWildcardType(name);
        ArrayList validators = new ArrayList();
        for (Method publicMethod : publicMethods = validatorObject.getClass().getMethods()) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            if (!nameIsWild && !validatorMethod.getName().equals(name)) continue;
            validators.add(ValidatorUtil.newValidator(validatorObject, validatorMethod.getMethod(), validatorMethod.getName()));
        }
        if (validatorObject instanceof Validator) {
            Validator validator = (Validator)validatorObject;
            QName vldName = validator.getName();
            if (vldName.equals(OBJECT_TYPE)) {
                validators.add(validator);
            } else if (nameIsWild || vldName.equals(name)) {
                validators.add(validator);
            } else if (ValidatorUtil.isAssignableFrom(vldName, name)) {
                validators.add(validator);
            }
            if (!nameIsWild) {
                validator.setName(name);
            }
        }
        if (validators.isEmpty()) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + validatorObject.getClass().getName() + "'.  Class does not support a validation for type '" + name + "'.");
        }
        return validators;
    }

    public static List<ValidatorTypes> listValidations(Class<?> clazz) {
        Method[] publicMethods;
        QName name;
        Object validatorObject;
        ArrayList<ValidatorTypes> validations = new ArrayList<ValidatorTypes>();
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Validator instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        if (validatorObject instanceof Validator && (name = ((Validator)validatorObject).getName()) != null) {
            ValidatorTypes validatorTypes = new ValidatorTypes(name);
            validations.add(validatorTypes);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("added: " + validatorTypes));
            }
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            ValidatorTypes validatorTypes = new ValidatorTypes(validatorMethod.getName());
            validations.add(validatorTypes);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("added: " + validatorTypes));
        }
        Collections.sort(validations, new ValidatorTypesComparator());
        if (LOGGER.isDebugEnabled()) {
            for (ValidatorTypes validatorTypes : validations) {
                LOGGER.debug((Object)("sorted: " + validatorTypes));
            }
        }
        return validations;
    }

    public static boolean isValidator(Class<?> clazz) {
        Method[] publicMethods;
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnnotation()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Validator.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            if (!publicMethod.isAnnotationPresent(org.switchyard.annotations.Validator.class)) continue;
            return true;
        }
        return false;
    }

    private static Validator newValidator(final Object validatorObject, final Method publicMethod, QName name) {
        if (!ValidationResult.class.isAssignableFrom(publicMethod.getReturnType())) {
            throw new SwitchYardException("Invalid method signature: @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "' must return org.switchyard.validate.ValidationResult.");
        }
        BaseValidator validator = new BaseValidator(name){

            public ValidationResult validate(Object subject) {
                try {
                    return (ValidationResult)ValidationResult.class.cast(publicMethod.invoke(validatorObject, subject));
                }
                catch (InvocationTargetException e) {
                    throw new SwitchYardException("Error executing @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", e.getCause());
                }
                catch (Exception e) {
                    throw new SwitchYardException("Error executing @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", (Throwable)e);
                }
            }

            public Class<?> getType() {
                return publicMethod.getParameterTypes()[0];
            }
        };
        return validator;
    }

    private static boolean isAssignableFrom(QName a, QName b) {
        if (QNameUtil.isJavaMessageType((QName)a) && QNameUtil.isJavaMessageType((QName)b)) {
            Class aType = QNameUtil.toJavaMessageType((QName)a);
            Class bType = QNameUtil.toJavaMessageType((QName)b);
            if (aType == null || bType == null) {
                return false;
            }
            return aType.isAssignableFrom(bType);
        }
        return false;
    }

    private static boolean isWildcardType(QName type) {
        return type.toString().equals("*");
    }

    private static ValidatorMethod toValidatorMethod(Method publicMethod, org.switchyard.annotations.Validator validatorAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw new SwitchYardException("Invalid @Validator method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must have exactly 1 parameter.");
        }
        Class<?> type = params[0];
        QName name = !validatorAnno.name().trim().equals("") ? QName.valueOf(validatorAnno.name().trim()) : JavaTypes.toMessageType(type);
        return new ValidatorMethod(name, publicMethod);
    }

    private static ValidatorFactory newValidatorFactory(ValidateModel validateModel) {
        ValidatorFactoryClass validatorFactoryClass = validateModel.getClass().getAnnotation(ValidatorFactoryClass.class);
        if (validatorFactoryClass == null) {
            throw new SwitchYardException("ValidateModel type '" + validateModel.getClass().getName() + "' is not annotated with an @ValidatorFactoryClass annotation.");
        }
        Class<? extends ValidatorFactory> factoryClass = validatorFactoryClass.value();
        if (!ValidatorFactory.class.isAssignableFrom(factoryClass)) {
            throw new SwitchYardException("Invalid ValidatorFactory implementation.  Must implement '" + ValidatorFactory.class.getName() + "'.");
        }
        try {
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to create an instance of ValidatorFactory '" + factoryClass.getName() + "'.  Class must have a public default constructor and not be abstract.");
        }
    }

    private static final class ValidatorTypesComparator
    implements Comparator<ValidatorTypes> {
        private ValidatorTypesComparator() {
        }

        @Override
        public int compare(ValidatorTypes vt1, ValidatorTypes vt2) {
            int c = String.valueOf(vt1.getName()).compareTo(String.valueOf(vt2.getName()));
            if (c == 0 && vt1 instanceof ValidatorMethod && vt2 instanceof ValidatorMethod) {
                ValidatorMethod vm1 = (ValidatorMethod)vt1;
                ValidatorMethod vm2 = (ValidatorMethod)vt2;
                c = String.valueOf(vm1.getMethod()).compareTo(String.valueOf(vm2.getMethod()));
            }
            return c;
        }
    }

    private static class ValidatorMethod
    extends ValidatorTypes {
        private Method _method;

        ValidatorMethod(QName name, Method publicMethod) {
            super(name);
            this._method = publicMethod;
        }

        private Method getMethod() {
            return this._method;
        }

        @Override
        public String toString() {
            return String.format("%s [name=%s, method=%s]", this.getClass().getSimpleName(), this.getName(), this.getMethod());
        }
    }
}

