/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.config.model;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.switchyard.common.cdi.CDIUtil;
import org.switchyard.common.type.classpath.AbstractTypeFilter;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scannable;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.config.model.validate.v1.V1ValidatesModel;
import org.switchyard.validate.config.model.ValidateNamespace;
import org.switchyard.validate.config.model.v1.V1JavaValidateModel;
import org.switchyard.validate.internal.ValidatorTypes;
import org.switchyard.validate.internal.ValidatorUtil;

public class ValidateSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        String switchyardNamespace = input.getSwitchyardNamespace();
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel(switchyardNamespace);
        V1ValidatesModel validatesModel = null;
        String validateNamespace = ValidateNamespace.DEFAULT.uri();
        if (switchyardNamespace != null) {
            if (switchyardNamespace.endsWith(":1.0")) {
                validateNamespace = ValidateNamespace.V_1_0.uri();
            } else if (switchyardNamespace.endsWith(":1.1")) {
                validateNamespace = ValidateNamespace.V_1_1.uri();
            }
        }
        List<Class<?>> validatorClasses = this.scanForValidators(input.getURLs());
        for (Class<?> validator : validatorClasses) {
            List<ValidatorTypes> supportedValidators = ValidatorUtil.listValidations(validator);
            for (ValidatorTypes supportedValidate : supportedValidators) {
                V1JavaValidateModel validateModel = new V1JavaValidateModel(validateNamespace);
                String bean = CDIUtil.getNamedAnnotationValue(validator);
                if (bean != null) {
                    validateModel.setBean(bean);
                } else {
                    validateModel.setClazz(validator.getName());
                }
                validateModel.setName(supportedValidate.getName());
                if (validatesModel == null) {
                    validatesModel = new V1ValidatesModel(switchyardNamespace);
                    switchyardModel.setValidates((ValidatesModel)validatesModel);
                }
                validatesModel.addValidate((ValidateModel)validateModel);
            }
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private List<Class<?>> scanForValidators(List<URL> urls) throws IOException {
        ValidatorInstanceOfFilter filter = new ValidatorInstanceOfFilter();
        ClasspathScanner scanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            scanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private class ValidatorInstanceOfFilter
    extends AbstractTypeFilter {
        private ValidatorInstanceOfFilter() {
        }

        public boolean matches(Class<?> clazz) {
            Scannable scannable = clazz.getAnnotation(Scannable.class);
            if (scannable != null && !scannable.value()) {
                return false;
            }
            return ValidatorUtil.isValidator(clazz);
        }
    }
}

