/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.Validator;
import org.switchyard.validate.internal.ValidateMessages;
import org.switchyard.validate.internal.ValidatorTypes;

public final class ValidatorUtil {
    private static final Logger LOGGER = Logger.getLogger(ValidatorUtil.class);
    private static final QName OBJECT_TYPE = JavaTypes.toMessageType(Object.class);

    private ValidatorUtil() {
    }

    public static Validator<?> newValidator(Class<?> clazz, QName name) {
        return ValidatorUtil.newValidators(clazz, name).iterator().next();
    }

    public static Collection<Validator<?>> newValidators(Class<?> clazz, QName name) {
        Object validatorObject;
        if (!ValidatorUtil.isValidator(clazz)) {
            throw ValidateMessages.MESSAGES.invalidValidatorClass(clazz.getName());
        }
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw ValidateMessages.MESSAGES.errorConstructingValidatorConstructorRequired(clazz.getName(), e);
        }
        return ValidatorUtil.newValidators(validatorObject, name);
    }

    public static Collection<Validator<?>> newValidators(Object validatorObject, QName name) {
        Method[] publicMethods;
        boolean nameIsWild = ValidatorUtil.isWildcardType(name);
        ArrayList validators = new ArrayList();
        for (Method publicMethod : publicMethods = validatorObject.getClass().getMethods()) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            if (!nameIsWild && !validatorMethod.getName().equals(name)) continue;
            validators.add(ValidatorUtil.newValidator(validatorObject, validatorMethod.getMethod(), validatorMethod.getName()));
        }
        if (validatorObject instanceof Validator) {
            Validator validator = (Validator)validatorObject;
            QName vldName = validator.getName();
            if (vldName.equals(OBJECT_TYPE)) {
                validators.add(validator);
            } else if (nameIsWild || vldName.equals(name)) {
                validators.add(validator);
            } else if (ValidatorUtil.isAssignableFrom(vldName, name)) {
                validators.add(validator);
            }
            if (!nameIsWild) {
                validator.setName(name);
            }
        }
        if (validators.isEmpty()) {
            throw ValidateMessages.MESSAGES.errorConstructingValidatorClassNotSupported(validatorObject.getClass().getName(), name.toString());
        }
        return validators;
    }

    public static List<ValidatorTypes> listValidations(Class<?> clazz) {
        QName name;
        Object validatorObject;
        ArrayList<ValidatorTypes> validations = new ArrayList<ValidatorTypes>();
        try {
            validatorObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw ValidateMessages.MESSAGES.errorConstructingValidatorMustHavePublicConstructor(clazz.getName(), e);
        }
        if (validatorObject instanceof Validator && (name = ((Validator)validatorObject).getName()) != null) {
            ValidatorTypes validatorTypes = new ValidatorTypes(name);
            validations.add(validatorTypes);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("added: " + validatorTypes));
            }
        }
        Method[] publicMethods = clazz.getMethods();
        for (Method publicMethod : publicMethods) {
            org.switchyard.annotations.Validator validatorAnno = publicMethod.getAnnotation(org.switchyard.annotations.Validator.class);
            if (validatorAnno == null) continue;
            ValidatorMethod validatorMethod = ValidatorUtil.toValidatorMethod(publicMethod, validatorAnno);
            ValidatorTypes validatorTypes = new ValidatorTypes(validatorMethod.getName());
            validations.add(validatorTypes);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("added: " + validatorTypes));
        }
        Collections.sort(validations, new ValidatorTypesComparator());
        if (LOGGER.isDebugEnabled()) {
            for (ValidatorTypes validatorTypes : validations) {
                LOGGER.debug((Object)("sorted: " + validatorTypes));
            }
        }
        return validations;
    }

    public static boolean isValidator(Class<?> clazz) {
        Method[] publicMethods;
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnnotation()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Validator.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            if (!publicMethod.isAnnotationPresent(org.switchyard.annotations.Validator.class)) continue;
            return true;
        }
        return false;
    }

    private static Validator newValidator(final Object validatorObject, final Method publicMethod, QName name) {
        if (!ValidationResult.class.isAssignableFrom(publicMethod.getReturnType())) {
            throw ValidateMessages.MESSAGES.invalidMethodSignatureMustReturnValidationResult(publicMethod.getName(), publicMethod.getDeclaringClass().getName());
        }
        BaseValidator validator = new BaseValidator(name){

            public ValidationResult validate(Object subject) {
                try {
                    return (ValidationResult)ValidationResult.class.cast(publicMethod.invoke(validatorObject, subject));
                }
                catch (InvocationTargetException e) {
                    throw ValidateMessages.MESSAGES.errorExecutingValidatorInvocationTargetException(publicMethod.getName(), publicMethod.getDeclaringClass().getName(), e);
                }
                catch (Exception e) {
                    throw ValidateMessages.MESSAGES.errorExecutingValidatorException(publicMethod.getName(), publicMethod.getDeclaringClass().getName(), e);
                }
            }

            public Class<?> getType() {
                return publicMethod.getParameterTypes()[0];
            }
        };
        return validator;
    }

    private static boolean isAssignableFrom(QName a, QName b) {
        if (QNameUtil.isJavaMessageType((QName)a) && QNameUtil.isJavaMessageType((QName)b)) {
            Class aType = QNameUtil.toJavaMessageType((QName)a);
            Class bType = QNameUtil.toJavaMessageType((QName)b);
            if (aType == null || bType == null) {
                return false;
            }
            return aType.isAssignableFrom(bType);
        }
        return false;
    }

    private static boolean isWildcardType(QName type) {
        return type.toString().equals("*");
    }

    private static ValidatorMethod toValidatorMethod(Method publicMethod, org.switchyard.annotations.Validator validatorAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw ValidateMessages.MESSAGES.invalidValidatorOneParameter(publicMethod.getName(), publicMethod.getDeclaringClass().getName());
        }
        Class<?> type = params[0];
        QName name = !validatorAnno.name().trim().equals("") ? QName.valueOf(validatorAnno.name().trim()) : JavaTypes.toMessageType(type);
        return new ValidatorMethod(name, publicMethod);
    }

    private static final class ValidatorTypesComparator
    implements Comparator<ValidatorTypes>,
    Serializable {
        private ValidatorTypesComparator() {
        }

        @Override
        public int compare(ValidatorTypes vt1, ValidatorTypes vt2) {
            int c = String.valueOf(vt1.getName()).compareTo(String.valueOf(vt2.getName()));
            if (c == 0 && vt1 instanceof ValidatorMethod && vt2 instanceof ValidatorMethod) {
                ValidatorMethod vm1 = (ValidatorMethod)vt1;
                ValidatorMethod vm2 = (ValidatorMethod)vt2;
                c = String.valueOf(vm1.getMethod()).compareTo(String.valueOf(vm2.getMethod()));
            }
            return c;
        }
    }

    private static class ValidatorMethod
    extends ValidatorTypes {
        private Method _method;

        ValidatorMethod(QName name, Method publicMethod) {
            super(name);
            this._method = publicMethod;
        }

        private Method getMethod() {
            return this._method;
        }

        @Override
        public String toString() {
            return String.format("%s [name=%s, method=%s]", this.getClass().getSimpleName(), this.getName(), this.getMethod());
        }
    }
}

